/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDuration;

public abstract class TGTimeSignature {
    private TGDuration denominator;
    private int numerator = 4;

    public TGTimeSignature(TGFactory tGFactory) {
        this.denominator = tGFactory.newDuration();
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int n) {
        this.numerator = n;
    }

    public TGDuration getDenominator() {
        return this.denominator;
    }

    public void setDenominator(TGDuration tGDuration) {
        this.denominator = tGDuration;
    }

    public TGTimeSignature clone(TGFactory tGFactory) {
        TGTimeSignature tGTimeSignature = tGFactory.newTimeSignature();
        this.copy(tGTimeSignature);
        return tGTimeSignature;
    }

    public void copy(TGTimeSignature tGTimeSignature) {
        tGTimeSignature.setNumerator(this.getNumerator());
        this.getDenominator().copy(tGTimeSignature.getDenominator());
    }

    public boolean isEqual(TGTimeSignature tGTimeSignature) {
        return this.getNumerator() == tGTimeSignature.getNumerator() && this.getDenominator().isEqual(tGTimeSignature.getDenominator());
    }
}

