/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

public class MidiTickPlayer {
    private static final int SECOND_IN_MILLIS = 1000;
    private int tempo;
    private long tick;
    private long time;
    private long lastTime;
    private long tickLength;

    public void process() {
        this.lastTime = this.time;
        this.time = System.currentTimeMillis();
        this.tick = (long)((float)this.tick + 960.0f * ((float)this.getTempo() * (float)(this.time - this.lastTime) / 60.0f) / 1000.0f);
    }

    public void clearTick() {
        this.tickLength = 0L;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int n) {
        this.tempo = n;
    }

    public long getTick() {
        return this.tick;
    }

    public void setTick(long l) {
        this.tick = l;
        this.time = System.currentTimeMillis();
    }

    public long getTickLength() {
        return this.tickLength;
    }

    public void notifyTick(long l) {
        this.tickLength = Math.max(this.tickLength, l);
    }
}

