/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGInputStream
extends TGStream
implements TGInputStreamBase {
    private DataInputStream dataInputStream;
    private String version;
    private TGFactory factory;

    public void init(TGFactory tGFactory, InputStream inputStream) {
        this.factory = tGFactory;
        this.dataInputStream = new DataInputStream(inputStream);
        this.version = null;
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("TuxGuitar", "*.tg");
    }

    public boolean isSupportedVersion(String string) {
        return string.equals("TuxGuitar File Format - 1.0");
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.version);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public TGSong readSong() throws TGFileFormatException {
        try {
            if (this.isSupportedVersion()) {
                TGSong tGSong = this.read();
                this.dataInputStream.close();
                return tGSong;
            }
            throw new TGFileFormatException("Unsopported Version");
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void readVersion() {
        if (this.version == null) {
            this.version = this.readUnsignedByteString();
        }
    }

    private TGSong read() {
        int n;
        TGSong tGSong = this.factory.newSong();
        tGSong.setName(this.readUnsignedByteString());
        tGSong.setArtist(this.readUnsignedByteString());
        tGSong.setAlbum(this.readUnsignedByteString());
        tGSong.setAuthor(this.readUnsignedByteString());
        int n2 = this.readShort();
        TGMeasureHeader tGMeasureHeader = null;
        long l = 960L;
        for (n = 0; n < n2; ++n) {
            TGMeasureHeader tGMeasureHeader2 = this.readMeasureHeader(n + 1, l, tGMeasureHeader);
            tGSong.addMeasureHeader(tGMeasureHeader2);
            l += tGMeasureHeader2.getLength();
            tGMeasureHeader = tGMeasureHeader2;
        }
        n = this.readByte();
        for (int i = 0; i < n; ++i) {
            tGSong.addTrack(this.readTrack(i + 1, tGSong));
        }
        return tGSong;
    }

    private TGTrack readTrack(int n, TGSong tGSong) {
        int n2;
        int n3 = this.readHeader();
        TGTrack tGTrack = this.factory.newTrack();
        tGTrack.setNumber(n);
        tGTrack.setName(this.readUnsignedByteString());
        this.readChannel(tGTrack.getChannel());
        int n4 = tGSong.countMeasureHeaders();
        TGMeasure tGMeasure = null;
        for (n2 = 0; n2 < n4; ++n2) {
            TGMeasure tGMeasure2 = this.readMeasure(tGSong.getMeasureHeader(n2), tGMeasure);
            tGTrack.addMeasure(tGMeasure2);
            tGMeasure = tGMeasure2;
        }
        n2 = this.readByte();
        for (int i = 0; i < n2; ++i) {
            tGTrack.getStrings().add(this.readInstrumentString(i + 1));
        }
        tGTrack.setOffset(-24 + this.readByte());
        this.readRGBColor(tGTrack.getColor());
        if ((n3 & 1) != 0) {
            this.readLyrics(tGTrack.getLyrics());
        }
        return tGTrack;
    }

    private TGMeasureHeader readMeasureHeader(int n, long l, TGMeasureHeader tGMeasureHeader) {
        int n2 = this.readHeader();
        TGMeasureHeader tGMeasureHeader2 = this.factory.newHeader();
        tGMeasureHeader2.setNumber(n);
        tGMeasureHeader2.setStart(l);
        if ((n2 & 1) != 0) {
            this.readTimeSignature(tGMeasureHeader2.getTimeSignature());
        } else if (tGMeasureHeader != null) {
            tGMeasureHeader.getTimeSignature().copy(tGMeasureHeader2.getTimeSignature());
        }
        if ((n2 & 2) != 0) {
            this.readTempo(tGMeasureHeader2.getTempo());
        } else if (tGMeasureHeader != null) {
            tGMeasureHeader.getTempo().copy(tGMeasureHeader2.getTempo());
        }
        tGMeasureHeader2.setRepeatOpen((n2 & 4) != 0);
        if ((n2 & 8) != 0) {
            tGMeasureHeader2.setRepeatClose(this.readShort());
        }
        if ((n2 & 0x10) != 0) {
            tGMeasureHeader2.setRepeatAlternative(this.readByte());
        }
        if ((n2 & 0x20) != 0) {
            tGMeasureHeader2.setMarker(this.readMarker(n));
        }
        tGMeasureHeader2.setTripletFeel(tGMeasureHeader != null ? tGMeasureHeader.getTripletFeel() : 1);
        if ((n2 & 0x40) != 0) {
            tGMeasureHeader2.setTripletFeel(this.readByte());
        }
        return tGMeasureHeader2;
    }

    private TGMeasure readMeasure(TGMeasureHeader tGMeasureHeader, TGMeasure tGMeasure) {
        int n = this.readHeader();
        TGMeasure tGMeasure2 = this.factory.newMeasure(tGMeasureHeader);
        TGStream.TGBeatData tGBeatData = new TGStream.TGBeatData(this, tGMeasure2);
        this.readBeats(tGMeasure2, tGBeatData);
        tGMeasure2.setClef(tGMeasure == null ? 1 : tGMeasure.getClef());
        if ((n & 1) != 0) {
            tGMeasure2.setClef(this.readByte());
        }
        tGMeasure2.setKeySignature(tGMeasure == null ? 0 : tGMeasure.getKeySignature());
        if ((n & 2) != 0) {
            tGMeasure2.setKeySignature(this.readByte());
        }
        return tGMeasure2;
    }

    private void readChannel(TGChannel tGChannel) {
        int n = this.readHeader();
        tGChannel.setChannel((short)this.readByte());
        tGChannel.setEffectChannel((short)this.readByte());
        tGChannel.setInstrument((short)this.readByte());
        tGChannel.setVolume((short)this.readByte());
        tGChannel.setBalance((short)this.readByte());
        tGChannel.setChorus((short)this.readByte());
        tGChannel.setReverb((short)this.readByte());
        tGChannel.setPhaser((short)this.readByte());
        tGChannel.setTremolo((short)this.readByte());
        tGChannel.setSolo((n & 1) != 0);
        tGChannel.setMute((n & 2) != 0);
    }

    private void readBeats(TGMeasure tGMeasure, TGStream.TGBeatData tGBeatData) {
        int n = 1;
        while (n & true) {
            n = this.readHeader();
            this.readBeat(n, tGMeasure, tGBeatData);
        }
    }

    private void readBeat(int n, TGMeasure tGMeasure, TGStream.TGBeatData tGBeatData) {
        TGBeat tGBeat = this.factory.newBeat();
        tGBeat.setStart(tGBeatData.getStart());
        if ((n & 2) != 0) {
            this.readDuration(tGBeatData.getDuration());
        }
        if ((n & 4) != 0) {
            this.readNotes(tGBeat, tGBeatData);
        }
        if ((n & 8) != 0) {
            this.readChord(tGBeat);
        }
        if ((n & 0x10) != 0) {
            this.readText(tGBeat);
        }
        tGBeatData.getDuration().copy(tGBeat.getDuration());
        tGMeasure.addBeat(tGBeat);
        tGBeatData.setStart(tGBeatData.getStart() + tGBeatData.getDuration().getTime());
    }

    private void readNotes(TGBeat tGBeat, TGStream.TGBeatData tGBeatData) {
        int n = 1;
        while (n & true) {
            n = this.readHeader();
            this.readNote(n, tGBeat, tGBeatData);
        }
    }

    private void readNote(int n, TGBeat tGBeat, TGStream.TGBeatData tGBeatData) {
        TGNote tGNote = this.factory.newNote();
        tGNote.setValue(this.readByte());
        tGNote.setString(this.readByte());
        tGNote.setTiedNote((n & 2) != 0);
        if ((n & 8) != 0) {
            tGBeatData.setVelocity(this.readByte());
        }
        tGNote.setVelocity(tGBeatData.getVelocity());
        if ((n & 4) != 0) {
            this.readNoteEffect(tGNote.getEffect());
        }
        tGBeat.addNote(tGNote);
    }

    private void readChord(TGBeat tGBeat) {
        TGChord tGChord = this.factory.newChord(this.readByte());
        tGChord.setName(this.readUnsignedByteString());
        tGChord.setFirstFret(this.readByte());
        for (int i = 0; i < tGChord.countStrings(); ++i) {
            tGChord.addFretValue(i, this.readByte());
        }
        tGBeat.setChord(tGChord);
    }

    private void readText(TGBeat tGBeat) {
        TGText tGText = this.factory.newText();
        tGText.setValue(this.readUnsignedByteString());
        tGBeat.setText(tGText);
    }

    private TGString readInstrumentString(int n) {
        TGString tGString = this.factory.newString();
        tGString.setNumber(n);
        tGString.setValue(this.readByte());
        return tGString;
    }

    private void readTempo(TGTempo tGTempo) {
        tGTempo.setValue(this.readShort());
    }

    private void readTimeSignature(TGTimeSignature tGTimeSignature) {
        tGTimeSignature.setNumerator(this.readByte());
        this.readDuration(tGTimeSignature.getDenominator());
    }

    private void readDuration(TGDuration tGDuration) {
        int n = this.readHeader();
        tGDuration.setDotted((n & 1) != 0);
        tGDuration.setDoubleDotted((n & 2) != 0);
        tGDuration.setValue(this.readByte());
        if ((n & 4) != 0) {
            this.readTupleto(tGDuration.getTupleto());
        } else {
            TGTupleto.NORMAL.copy(tGDuration.getTupleto());
        }
    }

    private void readTupleto(TGTupleto tGTupleto) {
        tGTupleto.setEnters(this.readByte());
        tGTupleto.setTimes(this.readByte());
    }

    private void readNoteEffect(TGNoteEffect tGNoteEffect) {
        int n = this.readHeader(3);
        if ((n & 1) != 0) {
            tGNoteEffect.setBend(this.readBendEffect());
        }
        if ((n & 2) != 0) {
            tGNoteEffect.setTremoloBar(this.readTremoloBarEffect());
        }
        if ((n & 4) != 0) {
            tGNoteEffect.setHarmonic(this.readHarmonicEffect());
        }
        if ((n & 8) != 0) {
            tGNoteEffect.setGrace(this.readGraceEffect());
        }
        if ((n & 0x10) != 0) {
            tGNoteEffect.setTrill(this.readTrillEffect());
        }
        if ((n & 0x20) != 0) {
            tGNoteEffect.setTremoloPicking(this.readTremoloPickingEffect());
        }
        tGNoteEffect.setVibrato((n & 0x40) != 0);
        tGNoteEffect.setDeadNote((n & 0x80) != 0);
        tGNoteEffect.setSlide((n & 0x100) != 0);
        tGNoteEffect.setHammer((n & 0x200) != 0);
        tGNoteEffect.setGhostNote((n & 0x400) != 0);
        tGNoteEffect.setAccentuatedNote((n & 0x800) != 0);
        tGNoteEffect.setHeavyAccentuatedNote((n & 0x1000) != 0);
        tGNoteEffect.setPalmMute((n & 0x2000) != 0);
        tGNoteEffect.setStaccato((n & 0x4000) != 0);
        tGNoteEffect.setTapping((n & 0x8000) != 0);
        tGNoteEffect.setSlapping((n & 0x10000) != 0);
        tGNoteEffect.setPopping((n & 0x20000) != 0);
        tGNoteEffect.setFadeIn((n & 0x40000) != 0);
    }

    private TGEffectBend readBendEffect() {
        TGEffectBend tGEffectBend = this.factory.newEffectBend();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readByte();
            int n3 = this.readByte();
            tGEffectBend.addPoint(n2, n3);
        }
        return tGEffectBend;
    }

    private TGEffectTremoloBar readTremoloBarEffect() {
        TGEffectTremoloBar tGEffectTremoloBar = this.factory.newEffectTremoloBar();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readByte();
            int n3 = this.readByte() - 12;
            tGEffectTremoloBar.addPoint(n2, n3);
        }
        return tGEffectTremoloBar;
    }

    private TGEffectHarmonic readHarmonicEffect() {
        TGEffectHarmonic tGEffectHarmonic = this.factory.newEffectHarmonic();
        tGEffectHarmonic.setType(this.readByte());
        if (tGEffectHarmonic.getType() != 1) {
            tGEffectHarmonic.setData(this.readByte());
        }
        return tGEffectHarmonic;
    }

    private TGEffectGrace readGraceEffect() {
        int n = this.readHeader();
        TGEffectGrace tGEffectGrace = this.factory.newEffectGrace();
        tGEffectGrace.setDead((n & 1) != 0);
        tGEffectGrace.setOnBeat((n & 2) != 0);
        tGEffectGrace.setFret(this.readByte());
        tGEffectGrace.setDuration(this.readByte());
        tGEffectGrace.setDynamic(this.readByte());
        tGEffectGrace.setTransition(this.readByte());
        return tGEffectGrace;
    }

    private TGEffectTremoloPicking readTremoloPickingEffect() {
        TGEffectTremoloPicking tGEffectTremoloPicking = this.factory.newEffectTremoloPicking();
        tGEffectTremoloPicking.getDuration().setValue(this.readByte());
        return tGEffectTremoloPicking;
    }

    private TGEffectTrill readTrillEffect() {
        TGEffectTrill tGEffectTrill = this.factory.newEffectTrill();
        tGEffectTrill.setFret(this.readByte());
        tGEffectTrill.getDuration().setValue(this.readByte());
        return tGEffectTrill;
    }

    private TGMarker readMarker(int n) {
        TGMarker tGMarker = this.factory.newMarker();
        tGMarker.setMeasure(n);
        tGMarker.setTitle(this.readUnsignedByteString());
        this.readRGBColor(tGMarker.getColor());
        return tGMarker;
    }

    private void readRGBColor(TGColor tGColor) {
        tGColor.setR(this.readByte() & 0xFF);
        tGColor.setG(this.readByte() & 0xFF);
        tGColor.setB(this.readByte() & 0xFF);
    }

    private void readLyrics(TGLyric tGLyric) {
        tGLyric.setFrom(this.readShort());
        tGLyric.setLyrics(this.readIntegerString());
    }

    private int readByte() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readHeader() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readHeader(int n) {
        int n2 = 0;
        for (int i = n; i > 0; --i) {
            n2 += this.readHeader() << 8 * i - 8;
        }
        return n2;
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private String readUnsignedByteString() {
        try {
            return this.readString(this.dataInputStream.read() & 0xFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private String readIntegerString() {
        try {
            return this.readString(this.dataInputStream.readInt());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private String readString(int n) {
        try {
            char[] cArray = new char[n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(cArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

