/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.herac.tuxguitar.gui.TuxGuitar;

public class WindowTitleUtil {
    private static final String VAR_START = "${";
    private static final String VAR_END = "}";
    public static final String VAR_APP_NAME = "appname";
    public static final String VAR_APP_VERSION = "appversion";
    public static final String VAR_FILE_NAME = "filename";
    public static final String VAR_FILE_PATH = "filepath";
    public static final String VAR_SONG_NAME = "songname";
    public static final String VAR_SONG_AUTHOR = "songauthor";
    public static final String VAR_SONG_ALBUM = "songalbum";
    public static final String VAR_SONG_ARTIST = "songartist";

    public static String parseTitle() {
        String string = WindowTitleUtil.parseString(TuxGuitar.instance().getConfig().getStringConfigValue("window.title"));
        return string == null ? "TuxGuitar" : string;
    }

    private static String parseString(String string) {
        try {
            if (string != null) {
                String string2 = new String();
                for (int i = 0; i < string.length(); ++i) {
                    int n;
                    int n2 = n = string.indexOf(VAR_START, i);
                    if (n >= 0) {
                        n2 = string.indexOf(VAR_END, n + VAR_START.length());
                    }
                    if (n >= 0 && n2 > n + VAR_START.length()) {
                        if (n > i) {
                            string2 = string2 + string.substring(i, n);
                        }
                    } else {
                        string2 = string2 + string.substring(i, string.length());
                        break;
                    }
                    String string3 = string.substring(n, n2 + 1);
                    string2 = string2 + WindowTitleUtil.parseVar(string3);
                    i = n2;
                }
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static String parseVar(String string) {
        String string2 = string.substring(VAR_START.length(), string.length() - 1);
        String string3 = string;
        if (string2.equals(VAR_APP_NAME)) {
            string3 = "TuxGuitar";
        } else if (string2.equals(VAR_APP_VERSION)) {
            string3 = "1.0-rc3";
        } else if (string2.equals(VAR_FILE_NAME)) {
            string3 = TuxGuitar.instance().getFileHistory().getCurrentFileName("Untitled.tg");
        } else if (string2.equals(VAR_FILE_PATH)) {
            string3 = TuxGuitar.instance().getFileHistory().getCurrentFilePath();
        } else if (string2.equals(VAR_SONG_NAME)) {
            string3 = TuxGuitar.instance().getSongManager().getSong().getName();
        } else if (string2.equals(VAR_SONG_AUTHOR)) {
            string3 = TuxGuitar.instance().getSongManager().getSong().getAuthor();
        } else if (string2.equals(VAR_SONG_ALBUM)) {
            string3 = TuxGuitar.instance().getSongManager().getSong().getAlbum();
        } else if (string2.equals(VAR_SONG_ARTIST)) {
            string3 = TuxGuitar.instance().getSongManager().getSong().getArtist();
        }
        return string3;
    }

    public static String getVar(String string) {
        return VAR_START + string + VAR_END;
    }
}

