/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.util.TGClassLoader;
import org.herac.tuxguitar.util.TGLibraryLoader;

public class TGFileUtils {
    private static final String TG_CONFIG_PATH = "tuxguitar.config.path";
    private static final String TG_SHARE_PATH = "tuxguitar.share.path";
    private static final String TG_DOC_PATH = "tuxguitar.doc.path";
    private static final String TG_CLASS_PATH = "tuxguitar.class.path";
    private static final String TG_LIBRARY_PATH = "tuxguitar.library.path";
    private static final String TG_LIBRARY_PREFIX = "tuxguitar.library.prefix";
    private static final String TG_LIBRARY_EXTENSION = "tuxguitar.library.extension";
    public static final String PATH_USER_CONFIG = TGFileUtils.getUserConfigDir();
    public static final String PATH_USER_PLUGINS_CONFIG = TGFileUtils.getUserPluginsConfigDir();
    public static final String PATH_SKINS = TGFileUtils.getSharePath("skins");
    public static final String PATH_LANGUAGE = TGFileUtils.getSharePath("lang");
    public static final String PATH_SCALES = TGFileUtils.getSharePath("scales");
    public static final String PATH_HELP = TGFileUtils.getDocPath("help");

    public static Image loadImage(String string) {
        return TGFileUtils.loadImage(TuxGuitar.instance().getConfig().getStringConfigValue("skin"), string);
    }

    public static Image loadImage(String string, String string2) {
        if (PATH_SKINS != null) {
            String string3 = PATH_SKINS + string + File.separator + string2;
            try {
                return new Image((Device)TuxGuitar.instance().getDisplay(), new ImageData(string3));
            }
            catch (Exception exception) {
                System.err.println(string3 + ": not found");
            }
        }
        return new Image((Device)TuxGuitar.instance().getDisplay(), 16, 16);
    }

    public static InputStream getResourceAsStream(String string) {
        return TGClassLoader.instance().getClassLoader().getResourceAsStream(string);
    }

    public static void loadClasspath() {
        String string;
        String string2 = TGFileUtils.getSharePath("plugins");
        if (string2 != null) {
            TGClassLoader.instance().addPaths(new File(string2));
        }
        if ((string = System.getProperty(TG_CLASS_PATH)) != null) {
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = 0; i < stringArray.length; ++i) {
                TGClassLoader.instance().addPaths(new File(stringArray[i]));
            }
        }
    }

    public static void loadLibraries() {
        String string = System.getProperty(TG_LIBRARY_PATH);
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            String string2 = System.getProperty(TG_LIBRARY_PREFIX);
            String string3 = System.getProperty(TG_LIBRARY_EXTENSION);
            for (int i = 0; i < stringArray.length; ++i) {
                TGLibraryLoader.instance().loadLibraries(new File(stringArray[i]), string2, string3);
            }
        }
    }

    private static String getUserConfigDir() {
        File file;
        String string = System.getProperty(TG_CONFIG_PATH);
        if (string == null) {
            string = System.getProperty("user.home") + File.separator + ".tuxguitar-" + "1.0-rc3";
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        return string;
    }

    private static String getUserPluginsConfigDir() {
        String string = TGFileUtils.getUserConfigDir() + File.separator + "plugins";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    private static String getSharePath(String string) {
        return TGFileUtils.getResourcePath(string, System.getProperty(TG_SHARE_PATH));
    }

    private static String getDocPath(String string) {
        return TGFileUtils.getResourcePath(string, System.getProperty(TG_DOC_PATH));
    }

    private static String getResourcePath(String string, String string2) {
        try {
            String string3 = null;
            if (string2 != null) {
                string3 = string2 + File.separator + string;
            } else {
                URL uRL = TGClassLoader.instance().getClassLoader().getResource(string);
                if (uRL != null) {
                    string3 = URLDecoder.decode(uRL.getPath(), "UTF-8");
                }
            }
            if (string3 != null) {
                return new File(string3).getAbsolutePath() + File.separator;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

