/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageUtils {
    public static void writeImage(ImageData imageData, OutputStream outputStream, int n) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(outputStream, n);
    }

    public static byte[] imageToByteArray(ImageData imageData, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageUtils.writeImage(imageData, byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static ImageData applyMask(ImageData imageData, RGB rGB, RGB rGB2) {
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, new PaletteData(new RGB[]{rGB2, rGB}));
        for (int i = 0; i < imageData2.width; ++i) {
            for (int j = 0; j < imageData2.height; ++j) {
                RGB rGB3 = imageData.palette.getRGB(imageData.getPixel(i, j));
                if (rGB3.red == rGB.red && rGB3.green == rGB.green && rGB3.blue == rGB.blue) {
                    imageData2.setPixel(i, j, imageData2.palette.getPixel(rGB2));
                    continue;
                }
                imageData2.setPixel(i, j, imageData2.palette.getPixel(rGB));
            }
        }
        return imageData2;
    }
}

