/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.io.base.TGFileFormat;

public class FileChooser {
    public static final String DEFAULT_OPEN_FILENAME = null;
    public static final String DEFAULT_SAVE_FILENAME = "Untitled.tg";
    public static TGFileFormat ALL_FORMATS = new TGFileFormat("All Files", "*.*");
    private static FileChooser instance;

    public static FileChooser instance() {
        if (instance == null) {
            instance = new FileChooser();
        }
        return instance;
    }

    private List list(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList;
    }

    public String open(Shell shell, TGFileFormat tGFileFormat) {
        return this.open(shell, this.list(tGFileFormat));
    }

    public String open(Shell shell, List list) {
        FilterList filterList = new FilterList(list);
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFileName(TuxGuitar.instance().getFileHistory().isLocalFile() ? this.getFileName(list, DEFAULT_OPEN_FILENAME) : null);
        fileDialog.setFilterPath(TuxGuitar.instance().getFileHistory().getOpenPath());
        fileDialog.setFilterNames(filterList.getFilterNames());
        fileDialog.setFilterExtensions(filterList.getFilterExtensions());
        return this.openDialog(fileDialog);
    }

    public String save(Shell shell, TGFileFormat tGFileFormat) {
        return this.save(shell, this.list(tGFileFormat));
    }

    public String save(Shell shell, List list) {
        FilterList filterList = new FilterList(list);
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFileName(this.getFileName(list, DEFAULT_SAVE_FILENAME));
        fileDialog.setFilterPath(TuxGuitar.instance().getFileHistory().getSavePath());
        fileDialog.setFilterNames(filterList.getFilterNames());
        fileDialog.setFilterExtensions(filterList.getFilterExtensions());
        return this.openDialog(fileDialog);
    }

    private String openDialog(FileDialog fileDialog) {
        String string = fileDialog.open();
        if (string != null) {
            TuxGuitar.instance().getFileHistory().setChooserPath(new File(string).getParent());
        }
        return string;
    }

    private String getFileName(List list, String string) {
        int n;
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string2 = TuxGuitar.instance().getFileHistory().getCurrentFileName(string);
        if (string2 != null && string2.length() > 0 && (n = string2.lastIndexOf(46)) > 0) {
            String[] stringArray;
            TGFileFormat tGFileFormat;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n).toLowerCase();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                tGFileFormat = (TGFileFormat)iterator.next();
                if (tGFileFormat.getSupportedFormats() == null || (stringArray = tGFileFormat.getSupportedFormats().split(TGFileFormat.EXTENSION_SEPARATOR)) == null || stringArray.length <= 0) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("*" + string4)) continue;
                    return string2;
                }
            }
            tGFileFormat = (TGFileFormat)list.get(0);
            if (tGFileFormat.getSupportedFormats() != null && (stringArray = tGFileFormat.getSupportedFormats().split(TGFileFormat.EXTENSION_SEPARATOR)) != null && stringArray.length > 0 && stringArray[0].length() > 1) {
                return string3 + stringArray[0].substring(1);
            }
        }
        return string;
    }

    private class FilterList {
        private String[] filterExtensions;
        private String[] filterNames;

        public FilterList(List list) {
            int n = list.size() + 2;
            this.filterNames = new String[n];
            this.filterExtensions = new String[n];
            this.filterNames[0] = new String("All Suported Formats");
            this.filterExtensions[0] = new String();
            for (int i = 1; i < n - 1; ++i) {
                TGFileFormat tGFileFormat = (TGFileFormat)list.get(i - 1);
                this.filterNames[i] = tGFileFormat.getName();
                this.filterExtensions[i] = tGFileFormat.getSupportedFormats();
                this.filterExtensions[0] = this.filterExtensions[0] + (i > 1 ? ";" : "");
                this.filterExtensions[0] = this.filterExtensions[0] + tGFileFormat.getSupportedFormats();
            }
            this.filterNames[n - 1] = new String("All Files");
            this.filterExtensions[n - 1] = new String("*.*");
        }

        public String[] getFilterExtensions() {
            return this.filterExtensions;
        }

        public String[] getFilterNames() {
            return this.filterNames;
        }
    }
}

