/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.system.lock.TGActionLock;

public class DialogUtils {
    public static final int OPEN_STYLE_WAIT = 1;
    public static final int OPEN_STYLE_PACK = 2;
    public static final int OPEN_STYLE_LAYOUT = 4;
    public static final int OPEN_STYLE_CENTER = 8;
    public static final int OPEN_STYLE_MAXIMIZED = 16;

    public static final Shell newDialog(Display display, int n) {
        return new Shell(display, n);
    }

    public static final Shell newDialog(Shell shell, int n) {
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        return new Shell(shell, n);
    }

    public static final void openDialog(Shell shell, int n) {
        DialogUtils.openDialog(shell, shell.getParent().getShell(), n);
    }

    public static final void openDialog(Shell shell, Shell shell2, int n) {
        Display display = shell.getDisplay();
        if ((n & 2) != 0) {
            shell.pack();
        }
        if ((n & 4) != 0) {
            shell.layout();
        }
        if ((n & 0x10) != 0) {
            shell.setMaximized(true);
        } else if ((n & 8) != 0) {
            int n2 = Math.max(0, shell2.getBounds().x + (shell2.getBounds().width - shell.getSize().x) / 2);
            int n3 = Math.max(0, shell2.getBounds().y + (shell2.getBounds().height - shell.getSize().y) / 2);
            shell.setLocation(n2, n3);
        }
        shell.open();
        shell2.setCursor(display.getSystemCursor(0));
        if ((n & 1) != 0) {
            if ((shell.getStyle() & 0x10000) == 0) {
                TGActionLock.unlock();
            }
            while (!display.isDisposed() && !shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }
}

