/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class ConfirmDialog {
    public static int BUTTON_CANCEL = 1;
    public static int BUTTON_YES = 2;
    public static int BUTTON_NO = 4;
    public static int STATUS_YES = 1;
    public static int STATUS_NO = 2;
    public static int STATUS_CANCEL = 3;
    protected Shell dialog;
    protected int status;
    private String message;

    public ConfirmDialog(String string) {
        this.message = string;
    }

    public int confirm(int n, int n2) {
        Shell shell = TuxGuitar.instance().getShell();
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        Label label2 = new Label(composite, 0);
        label.setImage(shell.getDisplay().getSystemImage(4));
        label2.setText(this.message);
        GridLayout gridLayout = new GridLayout(0, false);
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        if ((n & BUTTON_YES) != 0) {
            this.addCloseButton(TuxGuitar.getProperty("yes"), STATUS_YES, composite2, n2 == BUTTON_YES);
            ++gridLayout.numColumns;
        }
        if ((n & BUTTON_NO) != 0) {
            this.addCloseButton(TuxGuitar.getProperty("no"), STATUS_NO, composite2, n2 == BUTTON_NO);
            ++gridLayout.numColumns;
        }
        if ((n & BUTTON_CANCEL) != 0) {
            this.addCloseButton(TuxGuitar.getProperty("cancel"), STATUS_CANCEL, composite2, n2 == BUTTON_CANCEL);
            ++gridLayout.numColumns;
        }
        DialogUtils.openDialog(this.dialog, 11);
        return this.status;
    }

    private void addCloseButton(String string, final int n, Composite composite, boolean bl) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)this.getButtonData());
        button.setText(string);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfirmDialog.this.dialog.dispose();
                ConfirmDialog.this.status = n;
            }
        });
        if (bl) {
            this.dialog.setDefaultButton(button);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }
}

