/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableTrackLyric
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGLyric undoLyric = TuxGuitar.instance().getSongManager().getFactory().newLyric();
    private TGLyric redoLyric = TuxGuitar.instance().getSongManager().getFactory().newLyric();
    private int undoCaretPosition;
    private int redoCaretPosition;

    private UndoableTrackLyric() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGTrack tGTrack = TuxGuitar.instance().getSongManager().getTrack(this.trackNumber);
        this.redoLyric.copy(tGTrack.getLyrics());
        TuxGuitar.instance().getLyricEditor().setCaretPosition(this.redoCaretPosition);
        TuxGuitar.instance().getLyricEditor().update();
        TuxGuitar.instance().updateCache(false);
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGTrack tGTrack = TuxGuitar.instance().getSongManager().getTrack(this.trackNumber);
        this.undoLyric.copy(tGTrack.getLyrics());
        TuxGuitar.instance().getLyricEditor().setCaretPosition(this.undoCaretPosition);
        TuxGuitar.instance().getLyricEditor().update();
        TuxGuitar.instance().updateCache(false);
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackLyric startUndo(TGTrack tGTrack, int n) {
        UndoableTrackLyric undoableTrackLyric = new UndoableTrackLyric();
        undoableTrackLyric.doAction = 1;
        undoableTrackLyric.trackNumber = tGTrack.getNumber();
        undoableTrackLyric.undoCaret = new UndoableCaretHelper();
        undoableTrackLyric.undoCaretPosition = n;
        tGTrack.getLyrics().copy(undoableTrackLyric.undoLyric);
        return undoableTrackLyric;
    }

    public UndoableTrackLyric endUndo(TGTrack tGTrack, int n) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoCaretPosition = n;
        tGTrack.getLyrics().copy(this.redoLyric);
        return this;
    }
}

