/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableTrackInfo
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private String undoName;
    private String redoName;
    private TGColor undoColor;
    private TGColor redoColor;
    private int undoOffset;
    private int redoOffset;

    private UndoableTrackInfo() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.getTrackManager().changeInfo(tGSongManager.getTrack(this.trackNumber), this.redoName, this.redoColor.clone(tGSongManager.getFactory()), this.redoOffset);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.getTrackManager().changeInfo(tGSongManager.getTrack(this.trackNumber), this.undoName, this.undoColor.clone(tGSongManager.getFactory()), this.undoOffset);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackInfo startUndo(TGTrack tGTrack) {
        UndoableTrackInfo undoableTrackInfo = new UndoableTrackInfo();
        undoableTrackInfo.doAction = 1;
        undoableTrackInfo.trackNumber = tGTrack.getNumber();
        undoableTrackInfo.undoCaret = new UndoableCaretHelper();
        undoableTrackInfo.undoName = tGTrack.getName();
        undoableTrackInfo.undoColor = tGTrack.getColor().clone(TuxGuitar.instance().getSongManager().getFactory());
        undoableTrackInfo.undoOffset = tGTrack.getOffset();
        return undoableTrackInfo;
    }

    public UndoableTrackInfo endUndo(TGTrack tGTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoName = tGTrack.getName();
        this.redoColor = tGTrack.getColor().clone(TuxGuitar.instance().getSongManager().getFactory());
        this.redoOffset = tGTrack.getOffset();
        return this;
    }
}

