/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTempo;

public class UndoableChangeTempo
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private List undoableTempos = new ArrayList();
    private List redoableTempos = new ArrayList();

    private UndoableChangeTempo() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.setTempos(this.redoableTempos);
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.setTempos(this.undoableTempos);
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeTempo startUndo() {
        UndoableChangeTempo undoableChangeTempo = new UndoableChangeTempo();
        undoableChangeTempo.doAction = 1;
        undoableChangeTempo.undoCaret = new UndoableCaretHelper();
        undoableChangeTempo.getTempos(undoableChangeTempo.undoableTempos);
        return undoableChangeTempo;
    }

    public UndoableChangeTempo endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        this.getTempos(this.redoableTempos);
        return this;
    }

    private void getTempos(List list) {
        Iterator iterator = TuxGuitar.instance().getSongManager().getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            list.add(tGMeasureHeader.getTempo().clone(TuxGuitar.instance().getSongManager().getFactory()));
        }
    }

    private void setTempos(List list) {
        int n = list.size();
        if (n != TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders()) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TGTempo tGTempo = ((TGTempo)list.get(i)).clone(TuxGuitar.instance().getSongManager().getFactory());
            TuxGuitar.instance().getSongManager().changeTempo(TuxGuitar.instance().getSongManager().getMeasureHeader(i + 1), tGTempo);
        }
        TuxGuitar.instance().fireUpdate();
    }
}

