/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGString;

public class UndoableCaretHelper {
    private long position;
    private int track;
    private int string;
    private int velocity;
    private TGDuration duration;

    public UndoableCaretHelper() {
        Caret caret = UndoableCaretHelper.getCaret();
        this.track = caret.getTrack().getNumber();
        this.position = caret.getPosition();
        this.velocity = caret.getVelocity();
        this.duration = caret.getDuration().clone(TuxGuitar.instance().getSongManager().getFactory());
        this.string = 1;
        TGString tGString = caret.getSelectedString();
        if (tGString != null) {
            this.string = tGString.getNumber();
        }
    }

    public void update() {
        UndoableCaretHelper.getCaret().update(this.track, this.position, this.string, this.velocity);
        UndoableCaretHelper.getCaret().setSelectedDuration(this.duration.clone(TuxGuitar.instance().getSongManager().getFactory()));
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

