/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.scale.xml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.tools.scale.ScaleInfo;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScaleReader {
    private static final String SCALE_TAG = "scale";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String KEYS_ATTRIBUTE = "keys";

    public void loadScales(List list, String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                Document document = ScaleReader.getDocument(file);
                ScaleReader.loadScales(list, document.getFirstChild());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(file);
        return document;
    }

    private static void loadScales(List list, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(SCALE_TAG)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string2 = namedNodeMap.getNamedItem(NAME_ATTRIBUTE).getNodeValue();
            String string3 = namedNodeMap.getNamedItem(KEYS_ATTRIBUTE).getNodeValue();
            if (string2 == null || string3 == null || string2.trim().equals("") || string3.trim().equals("")) {
                throw new RuntimeException("Invalid Scale file format.");
            }
            list.add(new ScaleInfo(string2, string3));
        }
    }
}

