/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins.base;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.system.plugins.base.TGPluginBase;
import org.herac.tuxguitar.gui.tools.custom.TGCustomTool;
import org.herac.tuxguitar.gui.tools.custom.TGCustomToolManager;

public abstract class TGToolItemPlugin
extends TGPluginBase {
    private boolean loaded;
    private TGCustomTool tool;
    private TGCustomToolAction toolAction;

    protected abstract String getItemName();

    protected abstract void doAction();

    public void init(TuxGuitar tuxGuitar) {
        String string = this.getItemName();
        this.tool = new TGCustomTool(string, string);
        this.toolAction = new TGCustomToolAction(this.tool.getName());
    }

    public void close() {
        this.removePluin();
    }

    protected void addPluin() {
        if (!this.loaded) {
            TuxGuitar.instance().getActionManager().addAction(this.toolAction);
            TGCustomToolManager.instance().addCustomTool(this.tool);
            TuxGuitar.instance().getItemManager().createMenu();
            this.loaded = true;
        }
    }

    protected void removePluin() {
        if (this.loaded) {
            TGCustomToolManager.instance().removeCustomTool(this.tool);
            TuxGuitar.instance().getActionManager().removeAction(this.tool.getAction());
            TuxGuitar.instance().getItemManager().createMenu();
            this.loaded = false;
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.addPluin();
        } else {
            this.removePluin();
        }
    }

    protected class TGCustomToolAction
    extends Action {
        public TGCustomToolAction(String string) {
            super(string, 15);
        }

        protected int execute(TypedEvent typedEvent) {
            TGToolItemPlugin.this.doAction();
            return 0;
        }
    }
}

