/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins.base;

import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.plugins.TGPlugin;
import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.base.TGPluginBase;

public abstract class TGPluginList
extends TGPluginBase {
    private boolean enabled;
    private List plugins;

    public void init(TuxGuitar tuxGuitar) throws TGPluginException {
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            TGPlugin tGPlugin = (TGPlugin)iterator.next();
            tGPlugin.init(tuxGuitar);
        }
    }

    public void close() throws TGPluginException {
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            TGPlugin tGPlugin = (TGPlugin)iterator.next();
            tGPlugin.close();
        }
    }

    public void setEnabled(boolean bl) throws TGPluginException {
        this.enabled = bl;
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            TGPlugin tGPlugin = (TGPlugin)iterator.next();
            tGPlugin.setEnabled(this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Iterator getIterator() {
        if (this.plugins == null) {
            this.plugins = this.getPlugins();
        }
        return this.plugins.iterator();
    }

    protected abstract List getPlugins();
}

