/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingActionDefaults;
import org.herac.tuxguitar.gui.system.keybindings.editor.KeyBindingSelector;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class KeyBindingEditor {
    private static final int ACTION_WIDTH = 400;
    private static final int SHORTCUT_WIDTH = 100;
    protected Shell dialog;
    protected Table table;
    protected List items = new ArrayList();

    public void show(Shell shell) {
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        this.dialog.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 0, true, true));
        this.table = new Table(composite, 67588);
        this.table.setLayoutData((Object)new GridData(500, 250));
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TableItem tableItem = KeyBindingEditor.this.getSelectedItem();
                if (tableItem != null) {
                    KeyBindingAction keyBindingAction = (KeyBindingAction)tableItem.getData();
                    KeyBindingSelector keyBindingSelector = new KeyBindingSelector(KeyBindingEditor.this, keyBindingAction.getKeyBinding());
                    KeyBinding keyBinding = keyBindingSelector.select(KeyBindingEditor.this.dialog.getShell());
                    KeyBindingEditor.this.removeKeyBindingAction(keyBinding);
                    keyBindingAction.setKeyBinding(keyBinding);
                    KeyBindingEditor.this.loadTableItemLabel(tableItem);
                }
            }
        });
        TableColumn tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText(TuxGuitar.getProperty("key-bindings-editor-action-column"));
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn2.setText(TuxGuitar.getProperty("key-bindings-editor-shortcut-column"));
        this.loadAvailableActionKeyBindings();
        this.loadEnableActionKeyBindings(TuxGuitar.instance().getkeyBindingManager().getKeyBindingActions());
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("defaults"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBindingEditor.this.loadEnableActionKeyBindings(KeyBindingActionDefaults.getDefaultKeyBindings());
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("close"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBindingEditor.this.dialog.dispose();
            }
        });
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                KeyBindingEditor.this.save();
            }
        });
        this.table.setLayoutData((Object)new GridData(this.adjustWidth(tableColumn, 400) + this.adjustWidth(tableColumn2, 100), 250));
        this.dialog.setDefaultButton(button2);
        DialogUtils.openDialog(this.dialog, 10);
    }

    protected int adjustWidth(TableColumn tableColumn, int n) {
        tableColumn.pack();
        int n2 = tableColumn.getWidth();
        if (n2 < n) {
            n2 = n;
            tableColumn.setWidth(n2);
        }
        return n2;
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void loadTableItemLabel(TableItem tableItem) {
        if (tableItem.getData() instanceof KeyBindingAction) {
            KeyBindingAction keyBindingAction = (KeyBindingAction)tableItem.getData();
            String string = keyBindingAction.getAction();
            String string2 = keyBindingAction.getKeyBinding() != null ? keyBindingAction.getKeyBinding().toString() : "";
            tableItem.setText(new String[]{TuxGuitar.getProperty(string), string2});
        }
    }

    protected void loadAvailableActionKeyBindings() {
        List list = TuxGuitar.instance().getActionManager().getAvailableKeyBindingActions();
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setData((Object)new KeyBindingAction(string, null));
            this.items.add(tableItem);
        }
    }

    protected void loadEnableActionKeyBindings(List list) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TableItem tableItem = (TableItem)iterator.next();
            if (!(tableItem.getData() instanceof KeyBindingAction)) continue;
            KeyBindingAction keyBindingAction = (KeyBindingAction)tableItem.getData();
            KeyBinding keyBinding = null;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                KeyBindingAction keyBindingAction2 = (KeyBindingAction)iterator2.next();
                if (!keyBindingAction2.getAction().equals(keyBindingAction.getAction())) continue;
                keyBinding = (KeyBinding)keyBindingAction2.getKeyBinding().clone();
                break;
            }
            keyBindingAction.setKeyBinding(keyBinding);
            this.loadTableItemLabel(tableItem);
        }
    }

    protected void removeKeyBindingAction(KeyBinding keyBinding) {
        if (keyBinding != null) {
            Iterator iterator = this.items.iterator();
            while (iterator.hasNext()) {
                KeyBindingAction keyBindingAction;
                TableItem tableItem = (TableItem)iterator.next();
                if (!(tableItem.getData() instanceof KeyBindingAction) || !keyBinding.equals((keyBindingAction = (KeyBindingAction)tableItem.getData()).getKeyBinding())) continue;
                keyBindingAction.setKeyBinding(null);
                this.loadTableItemLabel(tableItem);
            }
        }
    }

    protected TableItem getSelectedItem() {
        TableItem tableItem = null;
        int n = this.table.getSelectionIndex();
        if (n >= 0) {
            tableItem = this.table.getItem(n);
        }
        return tableItem;
    }

    public boolean exists(KeyBinding keyBinding) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            KeyBindingAction keyBindingAction;
            TableItem tableItem = (TableItem)iterator.next();
            if (!(tableItem.getData() instanceof KeyBindingAction) || !keyBinding.equals((keyBindingAction = (KeyBindingAction)tableItem.getData()).getKeyBinding())) continue;
            return true;
        }
        return false;
    }

    protected void save() {
        ArrayList<KeyBindingAction> arrayList = new ArrayList<KeyBindingAction>();
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            KeyBindingAction keyBindingAction;
            TableItem tableItem = (TableItem)iterator.next();
            if (!(tableItem.getData() instanceof KeyBindingAction) || (keyBindingAction = (KeyBindingAction)tableItem.getData()).getAction() == null || keyBindingAction.getKeyBinding() == null) continue;
            arrayList.add(keyBindingAction);
        }
        TuxGuitar.instance().getkeyBindingManager().reset(arrayList);
        TuxGuitar.instance().getkeyBindingManager().saveKeyBindings();
    }
}

