/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.player.base.MidiPort;
import org.herac.tuxguitar.player.base.MidiSequencer;

public class SoundOption
extends Option {
    protected boolean initialized = false;
    protected String msCurrentKey;
    protected List msList;
    protected Combo msCombo;
    protected String mpCurrentKey;
    protected List mpList;
    protected Combo mpCombo;

    public SoundOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.sound"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionSound());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("midi.sequencer"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData());
        this.msCombo = new Combo(composite, 12);
        this.msCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("midi.port"));
        Composite composite2 = new Composite(this.getComposite(), 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)this.getTabbedData());
        this.mpCombo = new Combo(composite2, 12);
        this.mpCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                SoundOption.this.msList = TuxGuitar.instance().getPlayer().listSequencers();
                SoundOption.this.msCurrentKey = SoundOption.this.getConfig().getStringConfigValue("midi.sequencer");
                SoundOption.this.mpList = TuxGuitar.instance().getPlayer().listPorts();
                SoundOption.this.mpCurrentKey = SoundOption.this.getConfig().getStringConfigValue("midi.port");
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!SoundOption.this.isDisposed()) {
                            Object object;
                            int n;
                            for (n = 0; n < (this).SoundOption.this.msList.size(); ++n) {
                                object = (MidiSequencer)(this).SoundOption.this.msList.get(n);
                                (this).SoundOption.this.msCombo.add(object.getName());
                                if (!object.getKey().equals((this).SoundOption.this.msCurrentKey)) continue;
                                (this).SoundOption.this.msCombo.select(n);
                            }
                            if ((this).SoundOption.this.msCombo.getSelectionIndex() < 0 && (this).SoundOption.this.msCombo.getItemCount() > 0) {
                                (this).SoundOption.this.msCombo.select(0);
                            }
                            for (n = 0; n < (this).SoundOption.this.mpList.size(); ++n) {
                                object = (MidiPort)(this).SoundOption.this.mpList.get(n);
                                (this).SoundOption.this.mpCombo.add(((MidiPort)object).getName());
                                if (!((MidiPort)object).getKey().equals((this).SoundOption.this.mpCurrentKey)) continue;
                                (this).SoundOption.this.mpCombo.select(n);
                            }
                            if ((this).SoundOption.this.mpCombo.getSelectionIndex() < 0 && (this).SoundOption.this.mpCombo.getItemCount() > 0) {
                                (this).SoundOption.this.mpCombo.select(0);
                            }
                            (this).SoundOption.this.initialized = true;
                            SoundOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            int n;
            int n2 = this.msCombo.getSelectionIndex();
            if (n2 >= 0 && n2 < this.msList.size()) {
                this.getConfig().setProperty("midi.sequencer", ((MidiSequencer)this.msList.get(n2)).getKey());
            }
            if ((n = this.mpCombo.getSelectionIndex()) >= 0 && n < this.mpList.size()) {
                MidiPort midiPort = (MidiPort)this.mpList.get(n);
                this.getConfig().setProperty("midi.port", midiPort.getKey());
            }
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("midi.port", this.getDefaults().getProperty("midi.port"));
            this.getConfig().setProperty("midi.sequencer", this.getDefaults().getProperty("midi.sequencer"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            String string = this.getConfig().getStringConfigValue("midi.sequencer");
            if (bl || !TuxGuitar.instance().getPlayer().isSequencerOpen(string)) {
                TuxGuitar.instance().getPlayer().openSequencer(string);
            }
            String string2 = this.getConfig().getStringConfigValue("midi.port");
            if (bl || !TuxGuitar.instance().getPlayer().isMidiPortOpen(string2)) {
                TuxGuitar.instance().getPlayer().openPort(string2);
            }
        }
    }
}

