/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config;

import java.io.InputStream;
import java.util.Properties;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class TGConfigDefaults {
    private static final String DEFAULT_FILE = "config.dist";
    private static final String DEFAULT_FONT_NAME = TGConfigDefaults.getDefaultFontName();
    private Properties properties = new Properties();

    public TGConfigDefaults() {
        this.loadDefaults();
        this.loadDefaultFile();
    }

    public void loadDefaultFile() {
        try {
            InputStream inputStream = TGFileUtils.getResourceAsStream(DEFAULT_FILE);
            if (inputStream != null) {
                this.properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadDefaults() {
        this.loadProperty("skin", "Lavender");
        this.loadProperty("window.title", "${appname} - ${filename}");
        this.loadProperty("show.splash", true);
        this.loadProperty("window.maximized", false);
        this.loadProperty("window.width", 800);
        this.loadProperty("window.height", 600);
        this.loadProperty("show.mixer", false);
        this.loadProperty("show.transport", false);
        this.loadProperty("show.fretboard", false);
        this.loadProperty("show.piano", false);
        this.loadProperty("show.markers", false);
        this.loadProperty("layout.mode", 1);
        this.loadProperty("layout.style", 45);
        this.loadProperty("editor.mouse.mode", 2);
        this.loadProperty("editor.natural.key.mode", true);
        this.loadProperty("font.default", DEFAULT_FONT_NAME + ",6,0");
        this.loadProperty("font.note", DEFAULT_FONT_NAME + ",7,1");
        this.loadProperty("font.time-signature", DEFAULT_FONT_NAME + ",13,3");
        this.loadProperty("font.lyric", DEFAULT_FONT_NAME + ",7,2");
        this.loadProperty("font.text", DEFAULT_FONT_NAME + ",8,0");
        this.loadProperty("font.chord", DEFAULT_FONT_NAME + ",7,2");
        this.loadProperty("font.chord-fret", DEFAULT_FONT_NAME + ",5,0");
        this.loadProperty("font.grace", DEFAULT_FONT_NAME + ",6,0");
        this.loadProperty("font.printer.default", DEFAULT_FONT_NAME + ",6,0");
        this.loadProperty("font.printer.note", DEFAULT_FONT_NAME + ",6,0");
        this.loadProperty("font.printer.time-signature", DEFAULT_FONT_NAME + ",10,3");
        this.loadProperty("font.printer.lyric", DEFAULT_FONT_NAME + ",7,2");
        this.loadProperty("font.printer.text", DEFAULT_FONT_NAME + ",8,0");
        this.loadProperty("font.printer.chord", DEFAULT_FONT_NAME + ",7,2");
        this.loadProperty("font.printer.grace", DEFAULT_FONT_NAME + ",6,0");
        this.loadProperty("font.about.dialog.title", DEFAULT_FONT_NAME + ",36,3");
        this.loadProperty("color.background", "255,255,255");
        this.loadProperty("color.line", "150,150,150");
        this.loadProperty("color.score.note", "0,0,0");
        this.loadProperty("color.tab.note", "0,0,0");
        this.loadProperty("color.play.note", "255,0,0");
        this.loadProperty("history.max-files", 10);
        this.loadProperty("score.min.score-tab-spacing", 20);
        this.loadProperty("score.line-spacing", 8);
        this.loadProperty("tab.line-spacing", 10);
        this.loadProperty("first-track.spacing", 20);
        this.loadProperty("track.spacing", 10);
        this.loadProperty("language", "");
        this.loadProperty("fretboard.string-spacing", 20);
        this.loadProperty("fretboard.style", 2);
        this.loadProperty("fretboard.font", DEFAULT_FONT_NAME + ",8,1");
        this.loadProperty("fretboard.color.background", "0,0,0");
        this.loadProperty("fretboard.color.string", "227,217,217");
        this.loadProperty("fretboard.color.fret-point", "192,192,192");
        this.loadProperty("fretboard.color.note", "0,0,255");
        this.loadProperty("fretboard.color.scale", "255,0,0");
        this.loadProperty("piano.color.natural-key", "255,255,255");
        this.loadProperty("piano.color.not-natural-key", "0,0,0");
        this.loadProperty("piano.color.note", "0,0,255");
        this.loadProperty("piano.color.scale", "255,0,0");
        this.loadProperty("matrix.font", DEFAULT_FONT_NAME + ",8,1");
        this.loadProperty("matrix.color.foreground", "190,190,190");
        this.loadProperty("matrix.color.border", "25,25,25");
        this.loadProperty("matrix.color.position", "190,190,190");
        this.loadProperty("matrix.color.note", "0,0,255");
        this.loadProperty("matrix.color.play-note", "255,0,0");
        this.loadProperty("matrix.color.line-1", "255,255,255");
        this.loadProperty("matrix.color.line-2", "230,230,250");
        this.loadProperty("matrix.color.line-3", "173,216,230");
        this.loadProperty("table.auto-size", true);
        this.loadProperty("browser.lines-visible", true);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void loadProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    private void loadProperty(String string, int n) {
        this.properties.setProperty(string, Integer.toString(n));
    }

    private void loadProperty(String string, boolean bl) {
        this.properties.setProperty(string, Boolean.toString(bl));
    }

    private static String getDefaultFontName() {
        FontData[] fontDataArray;
        Font font = TuxGuitar.instance().getDisplay().getSystemFont();
        if (font != null && (fontDataArray = font.getFontData()) != null && fontDataArray.length > 0) {
            return fontDataArray[0].getName();
        }
        return new String();
    }
}

