/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class PrintPreview {
    private static final int SCROLL_INCREMENT = 50;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 40;
    private static final int MARGIN_LEFT = 50;
    private static final int MARGIN_RIGHT = 20;
    protected Shell dialog;
    protected Composite previewComposite;
    protected Composite pageComposite;
    protected Text currentText;
    protected Button previous;
    protected Button next;
    protected Rectangle bounds;
    protected List pages;
    protected int currentPage;

    public PrintPreview(List list, Rectangle rectangle) {
        this.pages = list;
        this.bounds = rectangle;
    }

    public void showPreview(Shell shell) {
        this.dialog = DialogUtils.newDialog(shell, 66800);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("print.preview"));
        this.initToolBar();
        this.initPreviewComposite();
        this.changePage(0);
        DialogUtils.openDialog(this.dialog, 17);
    }

    private void initToolBar() {
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.previous = new Button(composite, 16388);
        this.currentText = new Text(composite, 2048);
        this.currentText.setLayoutData((Object)new GridData(25, -1));
        this.next = new Button(composite, 131076);
        Label label = new Label(composite, 0);
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)this.getButtonData());
        this.currentText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    try {
                        Integer n = new Integer(PrintPreview.this.currentText.getText());
                        PrintPreview.this.changePage(n - 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PrintPreview.this.changePage(PrintPreview.this.currentPage);
                    }
                }
            }
        });
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PrintPreview.this.currentPage >= 0) {
                    PrintPreview.this.changePage(PrintPreview.this.currentPage - 1);
                }
            }
        });
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PrintPreview.this.currentPage >= 0) {
                    PrintPreview.this.changePage(PrintPreview.this.currentPage + 1);
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintPreview.this.dialog.dispose();
            }
        });
        label.setText(TuxGuitar.getProperty("print.preview.page-of") + " " + this.pages.size());
        button.setText(TuxGuitar.getProperty("close"));
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(131072, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void initPreviewComposite() {
        this.previewComposite = new Composite((Composite)this.dialog, 2560);
        this.previewComposite.setLayout((Layout)new GridLayout());
        this.previewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.previewComposite.setBackground(this.previewComposite.getDisplay().getSystemColor(15));
        this.previewComposite.setFocus();
        this.pageComposite = new Composite(this.previewComposite, 0x20000800);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setBackground(this.previewComposite.getDisplay().getSystemColor(1));
        this.pageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (PrintPreview.this.currentPage >= 0) {
                    PrintPreview.this.updateScroll();
                    int n = PrintPreview.this.previewComposite.getVerticalBar().getSelection();
                    TGPainter tGPainter = new TGPainter(paintEvent.gc);
                    tGPainter.drawImage((Image)PrintPreview.this.pages.get(PrintPreview.this.currentPage), 50, 20 - n);
                    tGPainter.dispose();
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = this.bounds.width - this.bounds.x + 70;
        gridData.heightHint = this.bounds.height - this.bounds.y + 60;
        this.pageComposite.setLayoutData((Object)gridData);
        this.previewComposite.getVerticalBar().setIncrement(50);
        this.previewComposite.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PrintPreview.this.pageComposite.redraw();
            }
        });
    }

    protected void updateScroll() {
        ScrollBar scrollBar = this.previewComposite.getVerticalBar();
        Rectangle rectangle = this.pageComposite.getClientArea();
        scrollBar.setMaximum(this.bounds.height - this.bounds.y + 60);
        scrollBar.setThumb(Math.min(this.bounds.height - this.bounds.y + 60, rectangle.height));
    }

    protected void changePage(int n) {
        if (!this.pages.isEmpty()) {
            int n2 = this.pages.size();
            if (n >= 0 && n < n2) {
                this.currentPage = n;
                this.currentText.setText(Integer.toString(n + 1));
                this.pageComposite.redraw();
            } else if (this.currentPage >= 0 && this.currentPage < n2) {
                this.currentText.setText(Integer.toString(this.currentPage + 1));
            }
            this.previous.setEnabled(this.currentPage > 0);
            this.next.setEnabled(this.currentPage + 1 < n2);
            this.previewComposite.getVerticalBar().setSelection(0);
            this.previewComposite.setFocus();
        } else {
            this.currentText.setEnabled(false);
            this.previous.setEnabled(false);
            this.next.setEnabled(false);
        }
    }
}

