/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.mixer.TGMixer;
import org.herac.tuxguitar.gui.mixer.TGMixerTrackChannel;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackChannel;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGMixerTrack {
    protected TGTrack track;
    protected TGMixer mixer;
    protected TGMixerTrackChannel mixerChannel;
    protected Button soloCheckBox;
    protected Button muteCheckBox;
    protected Scale balanceScale;
    protected Scale volumeScale;
    private Text volumeText;
    private Label volumeLabel;
    protected String tipVolume;
    protected String tipBalance;
    protected UndoableTrackChannel undoableVolume;
    protected UndoableTrackChannel undoableBalance;

    public TGMixerTrack(TGMixer tGMixer, TGTrack tGTrack) {
        this.mixer = tGMixer;
        this.track = tGTrack;
    }

    public void init(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.mixerChannel = new TGMixerTrackChannel(this);
        this.mixerChannel.init(composite2);
        this.soloCheckBox = new Button(composite2, 32);
        this.soloCheckBox.setSelection(this.track.getChannel().isSolo());
        this.soloCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UndoableTrackChannel undoableTrackChannel = UndoableTrackChannel.startUndo();
                TGMixerTrack.this.track.getChannel().setSolo(TGMixerTrack.this.soloCheckBox.getSelection());
                if (TGMixerTrack.this.track.getChannel().isSolo()) {
                    TGMixerTrack.this.track.getChannel().setMute(false);
                }
                TGMixerTrack.this.mixer.fireChanges(TGMixerTrack.this.track.getChannel(), 2);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackChannel.endUndo());
                TuxGuitar.instance().updateCache(true);
            }
        });
        this.muteCheckBox = new Button(composite2, 32);
        this.muteCheckBox.setSelection(this.track.getChannel().isMute());
        this.muteCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UndoableTrackChannel undoableTrackChannel = UndoableTrackChannel.startUndo();
                TGMixerTrack.this.track.getChannel().setMute(TGMixerTrack.this.muteCheckBox.getSelection());
                if (TGMixerTrack.this.track.getChannel().isMute()) {
                    TGMixerTrack.this.track.getChannel().setSolo(false);
                }
                TGMixerTrack.this.mixer.fireChanges(TGMixerTrack.this.track.getChannel(), 1);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackChannel.endUndo());
                TuxGuitar.instance().updateCache(true);
            }
        });
        this.balanceScale = new Scale(composite2, 256);
        this.balanceScale.setMaximum(127);
        this.balanceScale.setMinimum(0);
        this.balanceScale.setIncrement(1);
        this.balanceScale.setPageIncrement(64);
        this.balanceScale.setLayoutData((Object)this.getBalanceScaleData());
        this.volumeLabel = new Label(composite2, 0);
        this.volumeScale = new Scale(composite2, 512);
        this.volumeScale.setMaximum(127);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(16);
        this.volumeScale.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.volumeText = new Text(composite2, 16779268);
        this.volumeText.setEditable(false);
        this.volumeText.setLayoutData((Object)this.getVolumeTextData());
        this.balanceScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGMixerTrack.this.track.getChannel().setBalance((short)TGMixerTrack.this.balanceScale.getSelection());
                TGMixerTrack.this.balanceScale.setToolTipText(TGMixerTrack.this.tipBalance + ": " + TGMixerTrack.this.track.getChannel().getBalance());
                TGMixerTrack.this.mixer.fireChanges(TGMixerTrack.this.track.getChannel(), 8);
            }
        });
        this.balanceScale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TGMixerTrack.this.undoableBalance = UndoableTrackChannel.startUndo();
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (TGMixerTrack.this.undoableBalance != null) {
                    TuxGuitar.instance().getUndoableManager().addEdit(TGMixerTrack.this.undoableBalance.endUndo());
                    TuxGuitar.instance().getFileHistory().setUnsavedFile();
                    TuxGuitar.instance().updateCache(true);
                    TGMixerTrack.this.undoableBalance = null;
                }
            }
        });
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGMixerTrack.this.track.getChannel().setVolume((short)(TGMixerTrack.this.volumeScale.getMaximum() - TGMixerTrack.this.volumeScale.getSelection()));
                TGMixerTrack.this.volumeScale.setToolTipText(TGMixerTrack.this.tipVolume + ": " + TGMixerTrack.this.track.getChannel().getVolume());
                TGMixerTrack.this.mixer.fireChanges(TGMixerTrack.this.track.getChannel(), 4);
            }
        });
        this.volumeScale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TGMixerTrack.this.undoableVolume = UndoableTrackChannel.startUndo();
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (TGMixerTrack.this.undoableVolume != null) {
                    TuxGuitar.instance().getUndoableManager().addEdit(TGMixerTrack.this.undoableVolume.endUndo());
                    TuxGuitar.instance().getFileHistory().setUnsavedFile();
                    TuxGuitar.instance().updateCache(true);
                    TGMixerTrack.this.undoableVolume = null;
                }
            }
        });
        this.balanceScale.setSelection((int)this.track.getChannel().getBalance());
        this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.track.getChannel().getVolume());
        this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
    }

    private GridData getBalanceScaleData() {
        GridData gridData = new GridData(0x1000000, 0, false, true);
        gridData.widthHint = 65;
        return gridData;
    }

    private GridData getVolumeTextData() {
        GridData gridData = new GridData(0x1000000, 0, true, false);
        gridData.minimumWidth = 40;
        return gridData;
    }

    public void fireChanges(int n) {
        if ((n & 2) != 0 || (n & 1) != 0) {
            this.soloCheckBox.setSelection(this.track.getChannel().isSolo());
            this.muteCheckBox.setSelection(this.track.getChannel().isMute());
        }
        if ((n & 0x10) != 0 || (n & 4) != 0) {
            this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.track.getChannel().getVolume());
            this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
        }
        if ((n & 0x10) != 0 || (n & 8) != 0) {
            this.balanceScale.setSelection((int)this.track.getChannel().getBalance());
        }
        if ((n & 0x10) != 0) {
            this.mixerChannel.updateItems(true);
        }
    }

    public void loadProperties() {
        this.soloCheckBox.setText(TuxGuitar.getProperty("mixer.track.solo"));
        this.muteCheckBox.setText(TuxGuitar.getProperty("mixer.track.mute"));
        this.volumeLabel.setText(TuxGuitar.getProperty("mixer.channel.volume") + ":");
        this.tipVolume = TuxGuitar.getProperty("mixer.channel.volume");
        this.tipBalance = TuxGuitar.getProperty("mixer.channel.balance");
        this.volumeScale.setToolTipText(this.tipVolume + ": " + this.track.getChannel().getBalance());
        this.balanceScale.setToolTipText(this.tipBalance + ": " + this.track.getChannel().getBalance());
        this.mixerChannel.updateItems(true);
    }

    public void updateItems() {
        this.mixerChannel.updateItems(false);
    }

    public TGTrack getTrack() {
        return this.track;
    }

    public TGMixer getMixer() {
        return this.mixer;
    }
}

