/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.mixer.TGMixerTrack;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackChannel;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGMixer
implements IconLoader,
LanguageLoader {
    public static final int MUTE = 1;
    public static final int SOLO = 2;
    public static final int VOLUME = 4;
    public static final int BALANCE = 8;
    public static final int CHANNEL = 16;
    public static final int CHANGE_ALL = 31;
    protected Shell dialog;
    protected TGSongManager manager = TuxGuitar.instance().getSongManager();
    protected Scale volumeScale;
    protected Text volumeText;
    private Label volumeLabel;
    private List trackMixers = new ArrayList();
    protected String tipVolume;
    protected UndoableTrackChannel undoableVolume;

    public TGMixer() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2144);
        this.loadData();
        TuxGuitar.instance().updateCache(true);
        DialogUtils.openDialog(this.dialog, 9);
        TuxGuitar.instance().updateCache(true);
    }

    protected void loadData() {
        TGTrack tGTrack;
        this.trackMixers.clear();
        Iterator iterator = TuxGuitar.instance().getSongManager().getSong().getTracks();
        while (iterator.hasNext()) {
            tGTrack = (TGTrack)iterator.next();
            TGMixerTrack tGMixerTrack = new TGMixerTrack(this, tGTrack);
            tGMixerTrack.init((Composite)this.dialog);
            this.trackMixers.add(tGMixerTrack);
        }
        tGTrack = new Composite((Composite)this.dialog, 0);
        tGTrack.setLayout((Layout)new GridLayout());
        tGTrack.setLayoutData(new GridData(0x1000000, 4, true, true));
        this.volumeLabel = new Label((Composite)tGTrack, 0);
        this.volumeScale = new Scale((Composite)tGTrack, 512);
        this.volumeScale.setMaximum(10);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(1);
        this.volumeScale.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.volumeText = new Text((Composite)tGTrack, 16779268);
        this.volumeText.setEditable(false);
        this.volumeText.setLayoutData((Object)this.getVolumeTextData());
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                short s = (short)(TGMixer.this.volumeScale.getMaximum() - TGMixer.this.volumeScale.getSelection());
                if (s != TGMixer.this.manager.getSong().getVolume()) {
                    TGMixer.this.manager.getSong().setVolume(s);
                    TGMixer.this.volumeScale.setToolTipText(TGMixer.this.tipVolume + ": " + TGMixer.this.manager.getSong().getVolume());
                    TGMixer.this.volumeText.setText(Integer.toString(TGMixer.this.volumeScale.getMaximum() - TGMixer.this.volumeScale.getSelection()));
                    if (TuxGuitar.instance().getPlayer().isRunning()) {
                        TuxGuitar.instance().getPlayer().updateControllers();
                    }
                }
            }
        });
        this.volumeScale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TGMixer.this.undoableVolume = UndoableTrackChannel.startUndo();
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (TGMixer.this.undoableVolume != null) {
                    TuxGuitar.instance().getUndoableManager().addEdit(TGMixer.this.undoableVolume.endUndo());
                    TuxGuitar.instance().getFileHistory().setUnsavedFile();
                    TuxGuitar.instance().updateCache(true);
                    TGMixer.this.undoableVolume = null;
                }
            }
        });
        this.loadVolume();
        this.loadIcons();
        this.loadProperties();
        this.dialog.setLayout((Layout)new GridLayout(this.dialog.getChildren().length, false));
        this.dialog.pack();
    }

    private void loadVolume() {
        this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.manager.getSong().getVolume());
        this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
    }

    private GridData getVolumeTextData() {
        GridData gridData = new GridData(0x1000000, 0, true, false);
        gridData.minimumWidth = 40;
        return gridData;
    }

    protected void clear() {
        Control[] controlArray = this.dialog.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public synchronized void fireChanges(TGChannel tGChannel, int n) {
        Iterator iterator = this.trackMixers.iterator();
        while (iterator.hasNext()) {
            TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
            if (tGMixerTrack.getTrack().getChannel().getChannel() == tGChannel.getChannel()) {
                tGMixerTrack.getTrack().getChannel().setEffectChannel(tGChannel.getEffectChannel());
                tGMixerTrack.getTrack().getChannel().setVolume(tGChannel.getVolume());
                tGMixerTrack.getTrack().getChannel().setBalance(tGChannel.getBalance());
                tGMixerTrack.getTrack().getChannel().setChorus(tGChannel.getChorus());
                tGMixerTrack.getTrack().getChannel().setReverb(tGChannel.getReverb());
                tGMixerTrack.getTrack().getChannel().setPhaser(tGChannel.getPhaser());
                tGMixerTrack.getTrack().getChannel().setTremolo(tGChannel.getTremolo());
            }
            tGMixerTrack.fireChanges(n);
        }
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
    }

    public synchronized void loadProperties() {
        if (!this.isDisposed()) {
            Iterator iterator = this.trackMixers.iterator();
            while (iterator.hasNext()) {
                TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
                tGMixerTrack.loadProperties();
            }
            this.volumeLabel.setText(TuxGuitar.getProperty("mixer.volume") + ":");
            this.tipVolume = TuxGuitar.getProperty("mixer.volume");
            this.volumeScale.setToolTipText(this.tipVolume + ": " + this.manager.getSong().getVolume());
            this.dialog.setText(TuxGuitar.getProperty("mixer"));
            this.dialog.pack();
        }
    }

    public synchronized void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        }
    }

    public synchronized void updateItems() {
        if (!this.isDisposed()) {
            Iterator iterator = this.trackMixers.iterator();
            while (iterator.hasNext()) {
                TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
                tGMixerTrack.updateItems();
            }
        }
    }

    public synchronized void updateValues() {
        if (!this.isDisposed()) {
            this.loadVolume();
            Iterator iterator = this.trackMixers.iterator();
            while (iterator.hasNext()) {
                TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
                tGMixerTrack.fireChanges(31);
            }
        }
    }

    public synchronized void update() {
        if (!this.isDisposed()) {
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TGMixer.this.isDisposed()) {
                        TGMixer.this.clear();
                        TGMixer.this.loadData();
                        TGMixer.this.dialog.layout();
                    }
                }
            }).start();
        }
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }
}

