/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class EditToolItems
extends ToolItems {
    public static final String NAME = "edit.items";
    private ToolItem undo;
    private ToolItem redo;
    private ToolItem modeSelection;
    private ToolItem modeEdition;
    private ToolItem notNaturalKey;

    public EditToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.undo = new ToolItem(toolBar, 8);
        this.undo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.undo"));
        this.redo = new ToolItem(toolBar, 8);
        this.redo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.redo"));
        new ToolItem(toolBar, 2);
        this.modeSelection = new ToolItem(toolBar, 16);
        this.modeSelection.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-mouse-mode-selection"));
        this.modeEdition = new ToolItem(toolBar, 16);
        this.modeEdition.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = new ToolItem(toolBar, 32);
        this.notNaturalKey.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-natural-key"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.undo.setEnabled(!bl && TuxGuitar.instance().getUndoableManager().canUndo());
        this.redo.setEnabled(!bl && TuxGuitar.instance().getUndoableManager().canRedo());
        this.modeSelection.setSelection(this.getEditor().getTablature().getEditorKit().getMouseMode() == 1);
        this.modeSelection.setEnabled(!bl);
        this.modeEdition.setSelection(this.getEditor().getTablature().getEditorKit().getMouseMode() == 2);
        this.modeEdition.setEnabled(!bl);
        this.notNaturalKey.setSelection(!this.getEditor().getTablature().getEditorKit().isNatural());
        this.notNaturalKey.setEnabled(!bl && this.getEditor().getTablature().getEditorKit().getMouseMode() == 2);
    }

    public void loadProperties() {
        this.undo.setToolTipText(TuxGuitar.getProperty("edit.undo"));
        this.redo.setToolTipText(TuxGuitar.getProperty("edit.redo"));
        this.modeSelection.setToolTipText(TuxGuitar.getProperty("edit.mouse-mode-selection"));
        this.modeEdition.setToolTipText(TuxGuitar.getProperty("edit.mouse-mode-edition"));
        this.notNaturalKey.setToolTipText(TuxGuitar.getProperty("edit.not-natural-key"));
    }

    public void loadIcons() {
        this.undo.setImage(TuxGuitar.instance().getIconManager().getEditUndo());
        this.redo.setImage(TuxGuitar.instance().getIconManager().getEditRedo());
        this.modeSelection.setImage(TuxGuitar.instance().getIconManager().getEditModeSelection());
        this.modeEdition.setImage(TuxGuitar.instance().getIconManager().getEditModeEdition());
        this.notNaturalKey.setImage(TuxGuitar.instance().getIconManager().getEditModeEditionNotNatural());
    }
}

