/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;

public class CompositionMenuItem
implements MenuItems {
    private MenuItem compositionMenuItem;
    private Menu menu;
    private MenuItem timeSignature;
    private MenuItem tempo;
    private MenuItem clef;
    private MenuItem keySignature;
    private MenuItem repeatOpen;
    private MenuItem repeatClose;
    private MenuItem repeatAlternative;
    private MenuItem tripletFeel;
    private MenuItem properties;

    public CompositionMenuItem(Shell shell, Menu menu, int n) {
        this.compositionMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.timeSignature = new MenuItem(this.menu, 8);
        this.timeSignature.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.composition.change-time-signature"));
        this.tempo = new MenuItem(this.menu, 8);
        this.tempo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.composition.change-tempo"));
        this.clef = new MenuItem(this.menu, 8);
        this.clef.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.composition.change-clef"));
        this.keySignature = new MenuItem(this.menu, 8);
        this.keySignature.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.composition.change-key-signature"));
        this.tripletFeel = new MenuItem(this.menu, 8);
        this.tripletFeel.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.composition.change-triplet-feel"));
        new MenuItem(this.menu, 2);
        this.repeatOpen = new MenuItem(this.menu, 8);
        this.repeatOpen.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.open-repeat"));
        this.repeatClose = new MenuItem(this.menu, 8);
        this.repeatClose.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.close-repeat"));
        this.repeatAlternative = new MenuItem(this.menu, 8);
        this.repeatAlternative.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.repeat-alternative"));
        new MenuItem(this.menu, 2);
        this.properties = new MenuItem(this.menu, 8);
        this.properties.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.composition.change-info"));
        this.compositionMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.timeSignature.setEnabled(!bl);
        this.tempo.setEnabled(!bl);
        this.clef.setEnabled(!bl);
        this.keySignature.setEnabled(!bl);
        this.tripletFeel.setEnabled(!bl);
        this.repeatOpen.setEnabled(!bl);
        this.repeatClose.setEnabled(!bl);
        this.repeatAlternative.setEnabled(!bl);
    }

    public void loadProperties() {
        this.compositionMenuItem.setText(TuxGuitar.getProperty("composition"));
        this.timeSignature.setText(TuxGuitar.getProperty("composition.timesignature"));
        this.tempo.setText(TuxGuitar.getProperty("composition.tempo"));
        this.clef.setText(TuxGuitar.getProperty("composition.clef"));
        this.keySignature.setText(TuxGuitar.getProperty("composition.keysignature"));
        this.tripletFeel.setText(TuxGuitar.getProperty("composition.tripletfeel"));
        this.repeatOpen.setText(TuxGuitar.getProperty("repeat.open"));
        this.repeatClose.setText(TuxGuitar.getProperty("repeat.close"));
        this.repeatAlternative.setText(TuxGuitar.getProperty("repeat.alternative"));
        this.properties.setText(TuxGuitar.getProperty("composition.properties"));
    }

    public void loadIcons() {
        this.timeSignature.setImage(TuxGuitar.instance().getIconManager().getCompositionTimeSignature());
        this.tempo.setImage(TuxGuitar.instance().getIconManager().getCompositionTempo());
        this.repeatOpen.setImage(TuxGuitar.instance().getIconManager().getCompositionRepeatOpen());
        this.repeatClose.setImage(TuxGuitar.instance().getIconManager().getCompositionRepeatClose());
        this.repeatAlternative.setImage(TuxGuitar.instance().getIconManager().getCompositionRepeatAlternative());
        this.properties.setImage(TuxGuitar.instance().getIconManager().getSongProperties());
    }
}

