/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.TGChord;

public class ChordMenuItem
implements MenuItems {
    private MenuItem chordMenuItem;
    private Menu menu;
    private MenuItem insertChord;
    private MenuItem[] subMenuItems;
    private long lastEdit;

    public ChordMenuItem(Shell shell, Menu menu, int n) {
        this.chordMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.insertChord = new MenuItem(this.menu, 8);
        this.insertChord.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.chord"));
        new MenuItem(this.menu, 2);
        this.addItems();
        this.chordMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void addItems() {
        this.disposeItems();
        this.subMenuItems = new MenuItem[TuxGuitar.instance().getCustomChordManager().countChords()];
        for (int i = 0; i < this.subMenuItems.length; ++i) {
            TGChord tGChord = TuxGuitar.instance().getCustomChordManager().getChord(i);
            this.subMenuItems[i] = new MenuItem(this.menu, 8);
            this.subMenuItems[i].setData((Object)tGChord);
            this.subMenuItems[i].setText(tGChord.getName());
            this.subMenuItems[i].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.chord"));
        }
    }

    public void disposeItems() {
        if (this.subMenuItems != null) {
            for (int i = 0; i < this.subMenuItems.length; ++i) {
                this.subMenuItems[i].dispose();
            }
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 4 && this.subMenuItems != null && this.subMenuItems.length > 0) {
            ToolItem toolItem = (ToolItem)selectionEvent.widget;
            Rectangle rectangle = toolItem.getBounds();
            Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
            this.menu.setLocation(point.x, point.y + rectangle.height);
            this.menu.setVisible(true);
        } else {
            TuxGuitar.instance().getAction("action.insert.chord").process((TypedEvent)selectionEvent);
        }
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        if (this.lastEdit != TuxGuitar.instance().getCustomChordManager().getLastEdit()) {
            this.addItems();
            this.lastEdit = TuxGuitar.instance().getCustomChordManager().getLastEdit();
        }
        this.insertChord.setEnabled(!bl);
        for (int i = 0; i < this.subMenuItems.length; ++i) {
            this.subMenuItems[i].setEnabled(!bl);
        }
    }

    public void loadProperties() {
        this.chordMenuItem.setText(TuxGuitar.getProperty("chord"));
        this.insertChord.setText(TuxGuitar.getProperty("insert.chord"));
    }

    public void loadIcons() {
    }
}

