/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TablaturePaintListener;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.system.lock.TGSongLock;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.util.TGLock;

public class Tablature
extends Composite {
    private static final int SCROLL_DELAY = 15;
    private static final int SCROLL_INCREMENT = 50;
    private TGLock lock = new TGLock();
    private TGSongManager songManager;
    private Caret caret;
    private int width;
    private int height;
    private ViewLayout viewLayout;
    private EditorKit editorKit = new EditorKit(this);
    private TGBeatImpl playedBeat;
    private TGMeasureImpl playedMeasure;
    private int scrollX;
    private int scrollY;
    private boolean resetScroll;
    protected long lastVScrollTime;
    protected long lastHScrollTime;

    public Tablature(Composite composite) {
        this(composite, 0);
    }

    public Tablature(Composite composite, int n) {
        super(composite, n);
    }

    public void initGUI() {
        this.addPaintListener(new TablaturePaintListener(this));
        ScrollBar scrollBar = this.getHorizontalBar();
        scrollBar.setIncrement(50);
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Tablature.this.lastHScrollTime + 15L < System.currentTimeMillis()) {
                    Tablature.this.redraw();
                    Tablature.this.lastHScrollTime = System.currentTimeMillis();
                }
            }
        });
        ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar2.setIncrement(50);
        scrollBar2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Tablature.this.lastVScrollTime + 15L < System.currentTimeMillis()) {
                    Tablature.this.redraw();
                    Tablature.this.lastVScrollTime = System.currentTimeMillis();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Tablature.this.updateScroll();
            }
        });
    }

    public void initDefaults() {
        this.caret = new Caret(this);
    }

    public void updateTablature() {
        this.playedBeat = null;
        this.playedMeasure = null;
        this.getViewLayout().updateSong();
    }

    public void initCaret() {
        this.caret.update(1, 960L, 1);
    }

    public synchronized void paintTablature(TGPainter tGPainter) {
        if (!TGSongLock.isLocked()) {
            this.lock();
            try {
                this.checkScroll();
                Rectangle rectangle = this.getClientArea();
                ScrollBar scrollBar = this.getHorizontalBar();
                ScrollBar scrollBar2 = this.getVerticalBar();
                this.scrollX = scrollBar.getSelection();
                this.scrollY = scrollBar2.getSelection();
                this.getViewLayout().paint(tGPainter, rectangle, -this.scrollX, -this.scrollY);
                this.width = this.viewLayout.getWidth();
                this.height = this.viewLayout.getHeight();
                this.updateScroll();
                if (TuxGuitar.instance().getPlayer().isRunning()) {
                    this.redrawPlayingMode(tGPainter, true);
                } else if (this.getCaret().hasChanges()) {
                    this.getCaret().setChanges(false);
                    this.moveScrollTo(this.getCaret().getMeasure(), scrollBar, scrollBar2, rectangle);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.unlock();
        }
    }

    public void resetScroll() {
        this.resetScroll = true;
    }

    public void checkScroll() {
        if (this.resetScroll) {
            this.getHorizontalBar().setSelection(0);
            this.getVerticalBar().setSelection(0);
            this.resetScroll = false;
        }
    }

    public void updateScroll() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getClientArea();
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar.setMaximum(this.width);
        scrollBar2.setMaximum(this.height);
        scrollBar.setThumb(Math.min(rectangle.width, rectangle2.width));
        scrollBar2.setThumb(Math.min(rectangle.height, rectangle2.height));
    }

    public boolean moveScrollTo(TGMeasureImpl tGMeasureImpl) {
        return this.moveScrollTo(tGMeasureImpl, this.getHorizontalBar(), this.getVerticalBar(), this.getClientArea());
    }

    public boolean moveScrollTo(TGMeasureImpl tGMeasureImpl, ScrollBar scrollBar, ScrollBar scrollBar2, Rectangle rectangle) {
        boolean bl = false;
        if (tGMeasureImpl != null && tGMeasureImpl.getTs() != null) {
            int n = tGMeasureImpl.getPosX();
            int n2 = tGMeasureImpl.getPosY();
            int n3 = tGMeasureImpl.getWidth(this.getViewLayout());
            int n4 = tGMeasureImpl.getTs().getSize();
            int n5 = this.getViewLayout().getFirstMeasureSpacing();
            int n6 = this.getViewLayout().getFirstTrackSpacing();
            boolean bl2 = false;
            if (n < 0 || n + n3 > rectangle.width && (rectangle.width >= n3 + n5 || n > n5)) {
                scrollBar.setSelection(this.scrollX + n - n5);
                bl = true;
            }
            if (n2 < 0 || n2 + n4 > rectangle.height && (rectangle.height >= n4 + n6 || n2 > n6)) {
                scrollBar2.setSelection(this.scrollY + n2 - n6);
                bl = true;
            }
            if (!bl) {
                boolean bl3 = bl2 = this.scrollX != scrollBar.getSelection() || this.scrollY != scrollBar2.getSelection();
            }
            if (bl2 || bl) {
                this.redraw();
            }
        }
        return bl;
    }

    public void redraw() {
        if (!super.isDisposed() && !TGSongLock.isLocked()) {
            this.lock();
            this.playedBeat = null;
            this.playedMeasure = null;
            super.redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed() && !TGSongLock.isLocked()) {
            TGPainter tGPainter = new TGPainter(new GC((Drawable)this));
            this.redrawPlayingMode(tGPainter, false);
            tGPainter.dispose();
        }
    }

    private void redrawPlayingMode(TGPainter tGPainter, boolean bl) {
        if (!(super.isDisposed() || !bl && this.isLocked() || TGSongLock.isLocked())) {
            this.lock();
            try {
                TGMeasureImpl tGMeasureImpl = TuxGuitar.instance().getEditorCache().getPlayMeasure();
                TGBeatImpl tGBeatImpl = TuxGuitar.instance().getEditorCache().getPlayBeat();
                if (tGMeasureImpl != null && tGBeatImpl != null && tGMeasureImpl.hasTrack(this.getCaret().getTrack().getNumber()) && (!this.moveScrollTo(tGMeasureImpl) || bl)) {
                    boolean bl2;
                    boolean bl3 = bl2 = bl || this.playedMeasure == null || !this.playedMeasure.equals(tGMeasureImpl);
                    if (this.playedMeasure != null && this.playedBeat != null && !this.playedMeasure.isOutOfBounds() && this.playedMeasure.hasTrack(this.getCaret().getTrack().getNumber())) {
                        this.getViewLayout().paintPlayMode(tGPainter, this.playedMeasure, this.playedBeat, bl2);
                    }
                    if (!tGMeasureImpl.isOutOfBounds()) {
                        this.getViewLayout().paintPlayMode(tGPainter, tGMeasureImpl, tGBeatImpl, bl2);
                    }
                    this.playedBeat = tGBeatImpl;
                    this.playedMeasure = tGMeasureImpl;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.unlock();
        }
    }

    private void lock() {
        this.editorKit.tryBack();
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public Caret getCaret() {
        return this.caret;
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(TGSongManager tGSongManager) {
        this.songManager = tGSongManager;
    }

    public ViewLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(ViewLayout viewLayout) {
        if (this.getViewLayout() != null) {
            this.getViewLayout().disposeLayout();
        }
        this.viewLayout = viewLayout;
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setSelection(0);
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setSelection(0);
        }
        this.reloadStyles();
    }

    public void reloadStyles() {
        if (this.getViewLayout() != null) {
            this.getViewLayout().reloadStyles();
            this.setBackground(this.getViewLayout().getResources().getBackgroundColor());
        }
    }

    public void reloadViewLayout() {
        int n = TuxGuitar.instance().getConfig().getIntConfigValue("layout.style");
        int n2 = TuxGuitar.instance().getConfig().getIntConfigValue("layout.mode");
        n2 = n2 == 0 ? 2 : n2;
        switch (n2) {
            case 1: {
                this.setViewLayout(new PageViewLayout(this, n));
                break;
            }
            case 2: {
                this.setViewLayout(new LinearViewLayout(this, n));
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.getViewLayout().disposeLayout();
    }
}

