/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.util.MidiTickUtil;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;

public class Caret {
    private Tablature tablature;
    private TGTrackImpl selectedTrack;
    private TGMeasureImpl selectedMeasure;
    private TGDuration selectedDuration;
    private long position;
    private int string;
    private boolean changes;
    private int velocity;
    private TGNote selectedNote;
    private TGBeat selectedBeat;

    public Caret(Tablature tablature) {
        this.tablature = tablature;
        this.selectedDuration = this.getSongManager().getFactory().newDuration();
        this.string = 1;
        this.velocity = 95;
        this.changes = false;
    }

    public synchronized void update() {
        int n = this.selectedTrack != null ? this.selectedTrack.getNumber() : 1;
        this.update(n, this.position, this.string);
    }

    public synchronized void update(int n) {
        this.update(n, this.position, this.string);
    }

    public synchronized void update(int n, long l, int n2) {
        this.update(n, l, n2, this.getVelocity());
    }

    public synchronized void update(int n, long l, int n2, int n3) {
        long l2 = TuxGuitar.instance().getPlayer().isRunning() ? MidiTickUtil.getStart(TuxGuitar.instance().getPlayer().getTickPosition()) : l;
        TGTrackImpl tGTrackImpl = this.findTrack(n);
        TGMeasureImpl tGMeasureImpl = this.findMeasure(l2, tGTrackImpl);
        TGBeat tGBeat = this.findBeat(l2, tGMeasureImpl);
        if (tGTrackImpl != null && tGMeasureImpl != null && tGBeat != null) {
            this.moveTo(tGTrackImpl, tGMeasureImpl, tGBeat, n2);
        }
        this.setVelocity(n3);
    }

    public void moveTo(TGTrackImpl tGTrackImpl, TGMeasureImpl tGMeasureImpl, TGBeat tGBeat, int n) {
        this.selectedTrack = tGTrackImpl;
        this.selectedMeasure = tGMeasureImpl;
        this.selectedBeat = tGBeat;
        this.string = n;
        this.updatePosition();
        this.updateDuration();
        this.checkString();
        this.updateNote();
        this.updateBeat();
        this.checkTransport();
        this.setChanges(true);
    }

    private TGTrackImpl findTrack(int n) {
        TGTrackImpl tGTrackImpl = (TGTrackImpl)this.getSongManager().getTrack(n);
        if (tGTrackImpl == null) {
            tGTrackImpl = (TGTrackImpl)this.getSongManager().getFirstTrack();
        }
        return tGTrackImpl;
    }

    private TGMeasureImpl findMeasure(long l, TGTrackImpl tGTrackImpl) {
        TGMeasureImpl tGMeasureImpl = null;
        if (tGTrackImpl != null && (tGMeasureImpl = (TGMeasureImpl)this.getSongManager().getTrackManager().getMeasureAt(tGTrackImpl, l)) == null) {
            tGMeasureImpl = (TGMeasureImpl)this.getSongManager().getTrackManager().getFirstMeasure(tGTrackImpl);
        }
        return tGMeasureImpl;
    }

    private TGBeat findBeat(long l, TGMeasureImpl tGMeasureImpl) {
        TGMeasureManager tGMeasureManager;
        TGBeat tGBeat = null;
        if (tGMeasureImpl != null && (tGBeat = (tGMeasureManager = this.getSongManager().getMeasureManager()).getBeatIn(tGMeasureImpl, l)) == null) {
            tGBeat = tGMeasureManager.getFirstBeat(tGMeasureImpl.getBeats());
        }
        return tGBeat;
    }

    public synchronized void goToTickPosition() {
        long l = MidiTickUtil.getStart(TuxGuitar.instance().getPlayer().getTickPosition());
        if (!this.getSongManager().isAtPosition(this.selectedMeasure.getHeader(), l)) {
            this.update(this.selectedTrack.getNumber(), l, this.string);
            this.setChanges(true);
        }
    }

    public void paintCaret(ViewLayout viewLayout, TGPainter tGPainter) {
        if (!TuxGuitar.instance().getPlayer().isRunning() && this.selectedMeasure != null && this.selectedBeat instanceof TGBeatImpl) {
            TGBeatImpl tGBeatImpl = (TGBeatImpl)this.selectedBeat;
            if ((viewLayout.getStyle() & 8) != 0) {
                int n = this.tablature.getViewLayout().getStringSpacing();
                int n2 = tGBeatImpl.getMeasureImpl().getHeaderImpl().getLeftSpacing(viewLayout);
                int n3 = this.selectedMeasure.getPosX() + tGBeatImpl.getPosX() + tGBeatImpl.getSpacing() + n2 - 5;
                int n4 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(16) + (this.string * n - n) - 7;
                int n5 = 14;
                int n6 = 14;
                viewLayout.setCaretStyle(tGPainter);
                tGPainter.initPath();
                tGPainter.addRectangle(n3, n4, n5, n6);
                tGPainter.closePath();
            } else if ((viewLayout.getStyle() & 4) != 0) {
                int n = this.tablature.getViewLayout().getScoreLineSpacing();
                int n7 = tGBeatImpl.getMeasureImpl().getHeaderImpl().getLeftSpacing(viewLayout);
                float f = 2.0f * viewLayout.getScale();
                float f2 = (float)(this.selectedMeasure.getPosX() + tGBeatImpl.getPosX() + tGBeatImpl.getSpacing() + n7) - f;
                float f3 = f2 + (float)viewLayout.getResources().getScoreNoteWidth() + f;
                float f4 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(0) - n;
                float f5 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(18);
                viewLayout.setCaretStyle(tGPainter);
                tGPainter.initPath();
                tGPainter.moveTo(f2, f4);
                tGPainter.lineTo(f2 + (f3 - f2) / 2.0f, f4 + (float)n / 2.0f);
                tGPainter.lineTo(f3, f4);
                tGPainter.moveTo(f2, f5 + (float)n);
                tGPainter.lineTo(f2 + (f3 - f2) / 2.0f, f5 + (float)n / 2.0f);
                tGPainter.lineTo(f3, f5 + (float)n);
                tGPainter.closePath();
            }
        }
    }

    public boolean moveRight() {
        if (this.getSelectedBeat() != null) {
            TGMeasureImpl tGMeasureImpl = this.getMeasure();
            TGBeat tGBeat = this.getSongManager().getMeasureManager().getNextBeat(tGMeasureImpl.getBeats(), this.getSelectedBeat());
            if (tGBeat == null) {
                tGMeasureImpl = (TGMeasureImpl)this.getSongManager().getTrackManager().getNextMeasure(this.getMeasure());
                if (tGMeasureImpl == null) {
                    return false;
                }
                tGBeat = this.getSongManager().getMeasureManager().getFirstBeat(tGMeasureImpl.getBeats());
            }
            this.moveTo(this.getTrack(), tGMeasureImpl, tGBeat, this.getStringNumber());
        }
        return true;
    }

    public void moveLeft() {
        if (this.getSelectedBeat() != null) {
            TGMeasureImpl tGMeasureImpl = this.getMeasure();
            TGBeat tGBeat = this.getSongManager().getMeasureManager().getPreviousBeat(tGMeasureImpl.getBeats(), this.getSelectedBeat());
            if (tGBeat == null) {
                tGMeasureImpl = (TGMeasureImpl)this.getSongManager().getTrackManager().getPrevMeasure(this.getMeasure());
                if (tGMeasureImpl == null) {
                    return;
                }
                tGBeat = this.getSongManager().getMeasureManager().getLastBeat(tGMeasureImpl.getBeats());
            }
            this.moveTo(this.getTrack(), tGMeasureImpl, tGBeat, this.getStringNumber());
        }
    }

    private void updateDuration() {
        if (this.selectedBeat != null && !this.selectedBeat.isRestBeat()) {
            this.selectedBeat.getDuration().copy(this.selectedDuration);
        }
    }

    public void moveUp() {
        int n = this.selectedTrack.stringCount();
        int n2 = (this.string - 2 + n) % n + 1;
        this.setStringNumber(n2);
    }

    public void moveDown() {
        int n = this.selectedTrack.stringCount();
        int n2 = this.string % n + 1;
        this.setStringNumber(n2);
    }

    public void setStringNumber(int n) {
        this.string = n;
        this.updateNote();
    }

    public int getStringNumber() {
        return this.string;
    }

    public long getPosition() {
        return this.position;
    }

    public TGMeasureImpl getMeasure() {
        return this.selectedMeasure;
    }

    public TGTrackImpl getTrack() {
        return this.selectedTrack;
    }

    public TGDuration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(TGDuration tGDuration) {
        this.selectedDuration = tGDuration;
    }

    public TGString getSelectedString() {
        List list = this.selectedTrack.getStrings();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGString tGString = (TGString)iterator.next();
            if (tGString.getNumber() != this.string) continue;
            return tGString;
        }
        return null;
    }

    public void changeDuration(TGDuration tGDuration) {
        this.getSongManager().getMeasureManager().changeDuration(this.getMeasure(), this.getSelectedBeat(), tGDuration, true);
        this.setChanges(true);
    }

    private void updatePosition() {
        this.position = this.getSelectedBeat().getStart();
    }

    private void checkString() {
        int n = this.getTrack().getStrings().size();
        if (this.string > n) {
            this.string = n;
        }
    }

    private void checkTransport() {
        TuxGuitar.instance().getTransport().gotoMeasure(this.getMeasure().getHeader());
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int n) {
        this.velocity = n;
    }

    private void updateNote() {
        this.selectedNote = this.getSongManager().getMeasureManager().getNote(this.getMeasure(), this.getPosition(), this.getSelectedString().getNumber());
    }

    public TGNote getSelectedNote() {
        return this.selectedNote;
    }

    private void updateBeat() {
        this.selectedBeat = this.getSongManager().getMeasureManager().getBeat(this.getMeasure(), this.getPosition());
    }

    public TGBeatImpl getSelectedBeat() {
        return (TGBeatImpl)this.selectedBeat;
    }

    public TGSongManager getSongManager() {
        return this.tablature.getSongManager();
    }
}

