/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.fretboard;

import java.util.Iterator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.fretboard.FretBoardConfig;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.system.lock.TGSongLock;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.gui.util.TGMusicKeyUtils;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;

public class FretBoard
extends Composite {
    public static final int MAX_FRETS = 24;
    public static final int TOP_SPACING = 10;
    public static final int BOTTOM_SPACING = 10;
    private static final int STRING_SPACING = TuxGuitar.instance().getConfig().getIntConfigValue("fretboard.string-spacing");
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("fretboard");
    private FretBoardListener listener;
    private FretBoardConfig config;
    private Composite toolComposite;
    private Label durationLabel;
    private Button scale;
    private Button settings;
    private Image fretBoard;
    private TGBeat beat;
    private int[] frets;
    private int[] strings;
    private int fretSpacing;
    private boolean changes;
    private Point lastSize;
    private int duration;
    protected Combo handSelector;
    protected Composite fretBoardComposite;

    public FretBoard(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FormLayout());
        this.listener = new FretBoardListener();
        this.config = new FretBoardConfig();
        this.config.load();
        this.initToolBar();
        this.initEditor();
        this.loadIcons();
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo((Control)this.toolComposite);
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo((Control)this.fretBoardComposite);
    }

    private void initToolBar() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        this.toolComposite = new Composite((Composite)this, 0);
        ++gridLayout.numColumns;
        Button button = new Button(this.toolComposite, 16388);
        button.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.caret.go-left"));
        ++gridLayout.numColumns;
        Button button2 = new Button(this.toolComposite, 131076);
        button2.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.caret.go-right"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        Button button3 = new Button(this.toolComposite, 132);
        button3.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.decrement-duration"));
        ++gridLayout.numColumns;
        this.durationLabel = new Label(this.toolComposite, 2048);
        ++gridLayout.numColumns;
        Button button4 = new Button(this.toolComposite, 1028);
        button4.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.increment-duration"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        this.handSelector = new Combo(this.toolComposite, 12);
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(0);
        this.handSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = FretBoard.this.handSelector.getSelectionIndex();
                if (n == 0) {
                    FretBoard.this.initFrets(10, 1);
                } else {
                    FretBoard.this.initFrets(10, 2);
                }
                FretBoard.this.setChanges(true);
                FretBoard.this.fretBoardComposite.redraw();
            }
        });
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        this.scale = new Button(this.toolComposite, 8);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.tools.scale"));
        ++gridLayout.numColumns;
        this.settings = new Button(this.toolComposite, 8);
        this.settings.setImage(TuxGuitar.instance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.settings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FretBoard.this.configure();
            }
        });
        this.toolComposite.setLayoutData((Object)formData);
        this.toolComposite.setLayout((Layout)gridLayout);
    }

    private void makeToolSeparator(Composite composite) {
        Label label = new Label(composite, 2);
        label.setLayoutData((Object)new GridData(20, 20));
    }

    private void initEditor() {
        this.lastSize = new Point(0, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.toolComposite, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoardComposite = new Composite((Composite)this, 0x20000800);
        this.fretBoardComposite.setLayoutData((Object)formData);
        this.fretBoardComposite.setBackground(this.config.getColorBackground());
        this.fretBoardComposite.addMouseListener((MouseListener)this.listener);
        this.fretBoardComposite.addPaintListener((PaintListener)this.listener);
    }

    private void loadDurationImage(boolean bl) {
        int n = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (bl || this.duration != n) {
            this.duration = n;
            this.durationLabel.setImage(TuxGuitar.instance().getIconManager().getDuration(this.duration));
        }
    }

    private void calculateFretSpacing(int n) {
        this.fretSpacing = n / 24;
        int n2 = 0;
        for (int i = 0; i < 24; ++i) {
            n2 += i * 2;
        }
        this.fretSpacing += n2 / 24 + 2;
    }

    private void disposeFretBoardImage() {
        if (this.fretBoard != null && !this.fretBoard.isDisposed()) {
            this.fretBoard.dispose();
        }
    }

    protected void initFrets(int n, int n2) {
        block3: {
            int n3;
            block2: {
                this.frets = new int[24];
                n3 = n;
                if (n2 != 1) break block2;
                for (int i = 0; i < this.frets.length; ++i) {
                    this.frets[i] = n3;
                    n3 += this.fretSpacing - (i + 1) * 2;
                }
                break block3;
            }
            if (n2 != 2) break block3;
            for (int i = this.frets.length - 1; i >= 0; --i) {
                this.frets[i] = n3;
                n3 += this.fretSpacing - i * 2;
            }
        }
    }

    private void initStrings(int n) {
        int n2 = 10;
        this.strings = new int[n];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = n2 + STRING_SPACING * i;
        }
    }

    private void updateEditor() {
        if (this.isVisible()) {
            this.beat = TuxGuitar.instance().getPlayer().isRunning() ? TuxGuitar.instance().getEditorCache().getPlayBeat() : TuxGuitar.instance().getEditorCache().getEditBeat();
            if (this.strings.length != this.getStringCount()) {
                this.disposeFretBoardImage();
                this.initStrings(this.getStringCount());
                this.lastSize.y = 0;
            }
            int n = this.getClientArea().width;
            int n2 = this.getClientArea().height;
            if (this.lastSize.x != n || this.hasChanges()) {
                this.layout(this.getClientArea().width, this.handSelector.getSelectionIndex() + 1);
            }
            if (this.lastSize.y != n2) {
                TuxGuitar.instance().getFretBoardEditor().showFretBoard();
            }
            this.lastSize.x = n;
            this.lastSize.y = n2;
        }
    }

    private void paintFretBoard(TGPainter tGPainter) {
        if (this.fretBoard == null || this.fretBoard.isDisposed()) {
            int n;
            this.fretBoard = new Image((Device)this.getDisplay(), this.getClientArea().width, STRING_SPACING * (this.strings.length - 1) + 10 + 10);
            TGPainter tGPainter2 = new TGPainter(new GC((Drawable)this.fretBoard));
            tGPainter2.setBackground(this.config.getColorBackground());
            tGPainter2.initPath(2);
            tGPainter2.addRectangle(this.getClientArea());
            tGPainter2.closePath();
            Image image = TuxGuitar.instance().getIconManager().getFretboardFret();
            Image image2 = TuxGuitar.instance().getIconManager().getFretboardFirstFret();
            tGPainter2.drawImage(image2, 0, 0, image2.getBounds().width, image2.getBounds().height, this.frets[0] - 5, this.strings[0] - 5, image2.getBounds().width, this.strings[this.strings.length - 1]);
            this.paintFretPoints(tGPainter2, 0);
            for (n = 1; n < this.frets.length; ++n) {
                tGPainter2.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, this.frets[n], this.strings[0] - 5, image.getBounds().width, this.strings[this.strings.length - 1]);
                this.paintFretPoints(tGPainter2, n);
            }
            for (n = 0; n < this.strings.length; ++n) {
                tGPainter2.setForeground(this.config.getColorString());
                if (n > 2) {
                    tGPainter2.setLineWidth(2);
                }
                tGPainter2.initPath();
                tGPainter2.moveTo(this.frets[0], this.strings[n]);
                tGPainter2.lineTo(this.frets[this.frets.length - 1], this.strings[n]);
                tGPainter2.closePath();
            }
            this.paintScale(tGPainter2);
            tGPainter2.dispose();
        }
        tGPainter.drawImage(this.fretBoard, 0, 0);
    }

    private void paintFretPoints(TGPainter tGPainter, int n) {
        tGPainter.setBackground(this.config.getColorFretPoint());
        if (n + 1 < this.frets.length) {
            int n2 = (n + 1) % 12;
            tGPainter.setLineWidth(10);
            if (n2 == 0) {
                int n3 = this.getOvalSize();
                int n4 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n5 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 - STRING_SPACING;
                int n6 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 + STRING_SPACING;
                tGPainter.initPath(2);
                tGPainter.addOval(n4 - n3 / 2, n5 - n3 / 2, n3, n3);
                tGPainter.addOval(n4 - n3 / 2, n6 - n3 / 2, n3, n3);
                tGPainter.closePath();
            } else if (n2 == 3 || n2 == 5 || n2 == 7 || n2 == 9) {
                int n7 = this.getOvalSize();
                int n8 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n9 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2;
                tGPainter.initPath(2);
                tGPainter.addOval(n8 - n7 / 2, n9 - n7 / 2, n7, n7);
                tGPainter.closePath();
            }
            tGPainter.setLineWidth(1);
        }
    }

    private void paintScale(TGPainter tGPainter) {
        TGTrackImpl tGTrackImpl = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack();
        for (int i = 0; i < this.strings.length; ++i) {
            TGString tGString = tGTrackImpl.getString(i + 1);
            for (int j = 0; j < this.frets.length; ++j) {
                int n = (tGString.getValue() + j) % 12;
                if (!TuxGuitar.instance().getScaleManager().getScale().getNote(n)) continue;
                int n2 = this.frets[j];
                if (j > 0) {
                    n2 -= (n2 - this.frets[j - 1]) / 2;
                }
                int n3 = this.strings[i];
                if ((this.config.getStyle() & 2) != 0) {
                    this.paintKeyText(tGPainter, this.config.getColorScale(), n2, n3, NOTE_NAMES[n]);
                    continue;
                }
                this.paintKeyOval(tGPainter, this.config.getColorScale(), n2, n3);
            }
        }
        tGPainter.setForeground(this.config.getColorBackground());
    }

    private void paintNotes(TGPainter tGPainter) {
        if (this.beat != null) {
            TGTrackImpl tGTrackImpl = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack();
            Iterator iterator = this.beat.getNotes().iterator();
            while (iterator.hasNext()) {
                TGNote tGNote = (TGNote)iterator.next();
                int n = tGNote.getValue();
                int n2 = tGNote.getString() - 1;
                if (n < 0 || n >= this.frets.length || n2 < 0 || n2 >= this.strings.length) continue;
                int n3 = this.frets[n];
                if (n > 0) {
                    n3 -= (this.frets[n] - this.frets[n - 1]) / 2;
                }
                int n4 = this.strings[n2];
                if ((this.config.getStyle() & 1) != 0) {
                    int n5 = tGTrackImpl.getString(tGNote.getString()).getValue() + tGNote.getValue();
                    this.paintKeyText(tGPainter, this.config.getColorNote(), n3, n4, NOTE_NAMES[n5 % 12]);
                    continue;
                }
                this.paintKeyOval(tGPainter, this.config.getColorNote(), n3, n4);
            }
            tGPainter.setLineWidth(1);
        }
    }

    private void paintKeyOval(TGPainter tGPainter, Color color, int n, int n2) {
        int n3 = this.getOvalSize();
        tGPainter.setBackground(color);
        tGPainter.initPath(2);
        tGPainter.moveTo(n - n3 / 2, n2 - n3 / 2);
        tGPainter.addOval(n - n3 / 2, n2 - n3 / 2, n3, n3);
        tGPainter.closePath();
    }

    private void paintKeyText(TGPainter tGPainter, Color color, int n, int n2, String string) {
        tGPainter.setBackground(this.getDisplay().getSystemColor(1));
        tGPainter.setForeground(color);
        tGPainter.setFont(this.config.getFont());
        Point point = tGPainter.getStringExtent(string);
        tGPainter.initPath(2);
        tGPainter.addRectangle(n - point.x / 2, n2 - point.y / 2, point.x, point.y);
        tGPainter.closePath();
        tGPainter.drawString(string, n - point.x / 2, n2 - point.y / 2, true);
    }

    protected void paintEditor(TGPainter tGPainter) {
        if (!TGSongLock.isLocked()) {
            this.updateEditor();
            if (this.frets.length > 0 && this.strings.length > 0) {
                this.paintFretBoard(tGPainter);
                this.paintNotes(tGPainter);
            }
        }
    }

    protected void hit(int n, int n2) {
        int n3 = this.getFretIndex(n);
        int n4 = this.getStringIndex(n2);
        TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().setStringNumber(n4 + 1);
        if (!this.removeNote(n3, n4 + 1)) {
            this.addNote(n3, n4 + 1);
        }
    }

    private int getStringIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - this.strings[n2]);
            int n4 = Math.abs(n - this.strings[i]);
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private int getFretIndex(int n) {
        int n2 = this.frets.length;
        if (n - 10 <= this.frets[0] && this.frets[0] < this.frets[n2 - 1]) {
            return 0;
        }
        if (n + 10 >= this.frets[0] && this.frets[0] > this.frets[n2 - 1]) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (i + 1 >= n2 || (n <= this.frets[i] || n > this.frets[i + 1]) && (n <= this.frets[i + 1] || n > this.frets[i])) continue;
            return i + 1;
        }
        return n2 - 1;
    }

    private boolean removeNote(int n, int n2) {
        if (this.beat != null) {
            Iterator iterator = this.beat.getNotes().iterator();
            while (iterator.hasNext()) {
                TGNote tGNote = (TGNote)iterator.next();
                if (tGNote.getValue() != n || tGNote.getString() != n2) continue;
                UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
                TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
                tGSongManager.getMeasureManager().removeNote(tGNote);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                return true;
            }
        }
        return false;
    }

    private int getStringCount() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack().getStrings().size();
    }

    private int getOvalSize() {
        return STRING_SPACING / 2 + STRING_SPACING / 10;
    }

    private void addNote(int n, int n2) {
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        TGNote tGNote = tGSongManager.getFactory().newNote();
        tGNote.setValue(n);
        tGNote.setVelocity(caret.getVelocity());
        tGNote.setString(n2);
        TGDuration tGDuration = tGSongManager.getFactory().newDuration();
        caret.getDuration().copy(tGDuration);
        tGSongManager.getMeasureManager().addNote(caret.getMeasure(), caret.getPosition(), tGNote, tGDuration);
        TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        caret.getSelectedBeat().play();
    }

    protected void afterAction() {
        int n = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasure().getNumber();
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(n);
        TuxGuitar.instance().updateCache(true);
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void redraw() {
        if (!super.isDisposed() && !TGSongLock.isLocked()) {
            super.redraw();
            this.fretBoardComposite.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed() && !TGSongLock.isLocked()) {
            this.fretBoardComposite.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeFretBoardImage();
        this.config.dispose();
    }

    public void loadProperties() {
        int n = this.handSelector.getSelectionIndex();
        this.handSelector.removeAll();
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(n);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.setChanges(true);
        this.layout(true, true);
    }

    public void loadIcons() {
        this.settings.setImage(TuxGuitar.instance().getIconManager().getSettings());
        this.loadDurationImage(true);
        this.layout(true, true);
        this.layout(this.getClientArea().width, this.handSelector.getSelectionIndex() + 1);
    }

    public int getHeight() {
        int n = 2 * this.fretBoardComposite.getBorderWidth();
        int n2 = this.toolComposite.getBounds().height;
        int n3 = STRING_SPACING * (this.strings.length - 1) + 10 + 10;
        return n + n2 + n3;
    }

    public int getWidth() {
        return this.frets[this.frets.length - 1];
    }

    public void layout() {
        super.layout();
    }

    public void layout(int n, int n2) {
        this.disposeFretBoardImage();
        this.calculateFretSpacing(n);
        this.initFrets(10, n2);
        this.initStrings(this.getStringCount());
        this.setChanges(false);
    }

    protected void configure() {
        this.config.configure(this.getShell());
        this.setChanges(true);
        this.redraw();
    }

    public Composite getFretBoardComposite() {
        return this.fretBoardComposite;
    }

    private class FretBoardListener
    implements PaintListener,
    MouseListener {
        public void paintControl(PaintEvent paintEvent) {
            TGPainter tGPainter = new TGPainter(paintEvent.gc);
            FretBoard.this.paintEditor(tGPainter);
            tGPainter.dispose();
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (!TuxGuitar.instance().getPlayer().isRunning()) {
                FretBoard.this.getFretBoardComposite().setFocus();
                if (mouseEvent.button == 1) {
                    FretBoard.this.hit(mouseEvent.x, mouseEvent.y);
                    FretBoard.this.afterAction();
                } else {
                    TuxGuitar.instance().getAction("action.caret.go-right").process((TypedEvent)mouseEvent);
                }
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }
    }
}

