/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;

public class TremoloBarEditor {
    public static final int X_SPACING = 30;
    public static final int Y_SPACING = 10;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 25;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List points;
    protected Composite editor;
    protected DefaultTremoloBar[] defaultTremoloBars;
    protected TGEffectTremoloBar result;

    public TremoloBarEditor() {
        this.init();
    }

    private void init() {
        int n;
        this.x = new int[13];
        this.y = new int[25];
        this.width = 360;
        this.height = 240;
        this.points = new ArrayList();
        for (n = 0; n < this.x.length; ++n) {
            this.x[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.y.length; ++n) {
            this.y[n] = (n + 1) * 10;
        }
    }

    public TGEffectTremoloBar show(Shell shell, final TGNote tGNote) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("effects.tremolo-bar-editor"));
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor = new Composite(composite2, 0x20000800);
        this.editor.setBackground(this.editor.getDisplay().getSystemColor(1));
        this.editor.setLayoutData((Object)this.resizeData(new GridData(4, 4, true, true), this.getWidth() + 60, this.getHeight() + 20));
        this.editor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                TremoloBarEditor.this.paintEditor(tGPainter);
                tGPainter.dispose();
            }
        });
        this.editor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TremoloBarEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                TremoloBarEditor.this.editor.redraw();
            }
        });
        this.resetDefaultTremoloBars();
        final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite3, 2048);
        for (int i = 0; i < this.defaultTremoloBars.length; ++i) {
            list.add(this.defaultTremoloBars[i].getName());
        }
        list.select(0);
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = list.getSelectionIndex();
                if (n >= 0 && n < TremoloBarEditor.this.defaultTremoloBars.length) {
                    TremoloBarEditor.this.setTremoloBar(TremoloBarEditor.this.defaultTremoloBars[n].getTremoloBar());
                    TremoloBarEditor.this.editor.redraw();
                }
            }
        });
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, true), 80, 25));
        button.setText(TuxGuitar.getProperty("clean"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloBarEditor.this.result = null;
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloBarEditor.this.result = TremoloBarEditor.this.getTremoloBar();
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite3, 8);
        button3.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloBarEditor.this.result = tGNote.getEffect().getTremoloBar();
                shell2.dispose();
            }
        });
        if (tGNote.getEffect().isTremoloBar()) {
            this.setTremoloBar(tGNote.getEffect().getTremoloBar());
        } else {
            this.setTremoloBar(this.defaultTremoloBars[0].getTremoloBar());
        }
        shell2.setDefaultButton(button2);
        DialogUtils.openDialog(shell2, 11);
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n, int n2) {
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    protected void paintEditor(TGPainter tGPainter) {
        Point point;
        int n;
        for (n = 0; n < this.x.length; ++n) {
            this.setStyleX(tGPainter, n);
            tGPainter.initPath();
            tGPainter.moveTo(this.x[n], 10.0f);
            tGPainter.lineTo(this.x[n], 10 + this.height);
            tGPainter.closePath();
        }
        for (n = 0; n < this.y.length; ++n) {
            this.setStyleY(tGPainter, n);
            tGPainter.initPath();
            tGPainter.moveTo(30.0f, this.y[n]);
            tGPainter.lineTo(30 + this.width, this.y[n]);
            tGPainter.closePath();
        }
        Iterator iterator = null;
        Point point2 = null;
        tGPainter.setLineStyle(1);
        tGPainter.setLineWidth(2);
        tGPainter.setForeground(this.editor.getDisplay().getSystemColor(15));
        iterator = this.points.iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            if (point2 != null) {
                tGPainter.initPath();
                tGPainter.moveTo(point2.x, point2.y);
                tGPainter.lineTo(point.x, point.y);
                tGPainter.closePath();
            }
            point2 = point;
        }
        tGPainter.setLineWidth(5);
        tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        iterator = this.points.iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            tGPainter.initPath();
            tGPainter.addRectangle(point.x - 2, point.y - 2, 5.0f, 5.0f);
            tGPainter.closePath();
        }
        tGPainter.setLineWidth(1);
    }

    private void setStyleX(TGPainter tGPainter, int n) {
        tGPainter.setLineStyle(1);
        if (n == 0 || n == 12) {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(9));
            if (n % 3 > 0) {
                tGPainter.setLineStyle(3);
            }
        }
    }

    private void setStyleY(TGPainter tGPainter, int n) {
        tGPainter.setLineStyle(1);
        if (n == 0 || n == 24) {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else if (n == 12) {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(3));
            if (n % 2 > 0) {
                tGPainter.setLineStyle(3);
                tGPainter.setForeground(this.editor.getDisplay().getSystemColor(15));
            }
        }
    }

    protected void checkPoint(int n, int n2) {
        Point point = new Point(this.getX(n), this.getY(n2));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    private boolean removePoint(Point point) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point2 = (Point)iterator.next();
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    private void removePointsAtXLine(int n) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getX(int n) {
        int n2 = -1;
        for (int i = 0; i < this.x.length; ++i) {
            if (n2 < 0) {
                n2 = this.x[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.x[i]);
            if (n4 >= n3) continue;
            n2 = this.x[i];
        }
        return n2;
    }

    private int getY(int n) {
        int n2 = -1;
        for (int i = 0; i < this.y.length; ++i) {
            if (n2 < 0) {
                n2 = this.y[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.y[i]);
            if (n4 >= n3) continue;
            n2 = this.y[i];
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public TGEffectTremoloBar getTremoloBar() {
        if (this.points != null && !this.points.isEmpty()) {
            TGEffectTremoloBar tGEffectTremoloBar = TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar();
            Iterator iterator = this.points.iterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                this.addTremoloBarPoint(tGEffectTremoloBar, point);
            }
            return tGEffectTremoloBar;
        }
        return null;
    }

    private void addTremoloBarPoint(TGEffectTremoloBar tGEffectTremoloBar, Point point) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.x.length; ++n) {
            if (point.x != this.x[n]) continue;
            n2 = n;
        }
        for (n = 0; n < this.y.length; ++n) {
            if (point.y != this.y[n]) continue;
            n3 = 12 - n;
        }
        tGEffectTremoloBar.addPoint(n2, n3);
    }

    public void setTremoloBar(TGEffectTremoloBar tGEffectTremoloBar) {
        this.points.clear();
        Iterator iterator = tGEffectTremoloBar.getPoints().iterator();
        while (iterator.hasNext()) {
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint = (TGEffectTremoloBar.TremoloBarPoint)iterator.next();
            this.makePoint(tremoloBarPoint);
        }
    }

    private void makePoint(TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint) {
        int n = tremoloBarPoint.getPosition();
        int n2 = this.y.length - 12 - tremoloBarPoint.getValue() - 1;
        if (n >= 0 && n < this.x.length && n2 >= 0 && n2 < this.y.length) {
            Point point = new Point(0, 0);
            point.x = this.x[n];
            point.y = this.y[n2];
            this.points.add(point);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void resetDefaultTremoloBars() {
        this.defaultTremoloBars = new DefaultTremoloBar[6];
        this.defaultTremoloBars[0] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.dip"), TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[0].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[0].getTremoloBar().addPoint(6, -2);
        this.defaultTremoloBars[0].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[1] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.dive"), TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[1].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[1].getTremoloBar().addPoint(9, -2);
        this.defaultTremoloBars[1].getTremoloBar().addPoint(12, -2);
        this.defaultTremoloBars[2] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.release-up"), TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[2].getTremoloBar().addPoint(0, -2);
        this.defaultTremoloBars[2].getTremoloBar().addPoint(9, -2);
        this.defaultTremoloBars[2].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[3] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.inverted-dip"), TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[3].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[3].getTremoloBar().addPoint(6, 2);
        this.defaultTremoloBars[3].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[4] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.return"), TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[4].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[4].getTremoloBar().addPoint(9, 2);
        this.defaultTremoloBars[4].getTremoloBar().addPoint(12, 2);
        this.defaultTremoloBars[5] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.release-down"), TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[5].getTremoloBar().addPoint(0, 2);
        this.defaultTremoloBars[5].getTremoloBar().addPoint(9, 2);
        this.defaultTremoloBars[5].getTremoloBar().addPoint(12, 0);
    }

    private class DefaultTremoloBar {
        private String name;
        private TGEffectTremoloBar tremoloBar;

        public DefaultTremoloBar(String string, TGEffectTremoloBar tGEffectTremoloBar) {
            this.name = string;
            this.tremoloBar = tGEffectTremoloBar;
        }

        public TGEffectTremoloBar getTremoloBar() {
            return this.tremoloBar;
        }

        public String getName() {
            return this.name;
        }
    }
}

