/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.ChordCreatorListener;
import org.herac.tuxguitar.gui.editors.chord.ChordCreatorUtil;
import org.herac.tuxguitar.gui.editors.chord.ChordDatabase;
import org.herac.tuxguitar.gui.editors.chord.ChordDialog;
import org.herac.tuxguitar.gui.editors.chord.ChordSettingsDialog;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.TGMusicKeyUtils;

public class ChordSelector
extends Composite {
    public static final String[][] KEY_NAMES = new String[][]{TGMusicKeyUtils.getSharpKeyNames("chord"), TGMusicKeyUtils.getFlatKeyNames("chord")};
    private ChordDialog dialog;
    private int[] tuning;
    private org.eclipse.swt.widgets.List tonicList;
    private org.eclipse.swt.widgets.List chordList;
    private org.eclipse.swt.widgets.List alterationList;
    private Button sharpButton;
    private Button flatButton;
    private Combo bassCombo;
    private Button addCheck;
    private org.eclipse.swt.widgets.List plusMinusList;
    private org.eclipse.swt.widgets.List _5List;
    private org.eclipse.swt.widgets.List _9List;
    private org.eclipse.swt.widgets.List _11List;
    private boolean refresh;

    public ChordSelector(ChordDialog chordDialog, Composite composite, int n, int[] nArray) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(3, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.dialog = chordDialog;
        this.tuning = nArray;
        this.refresh = true;
        this.init();
    }

    public void init() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)this.dialog.gridLayout(1, false, 0, 0));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tonicList = new org.eclipse.swt.widgets.List(composite, 2048);
        this.tonicList.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.dialog.gridLayout(2, true, 0, 0));
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 28;
        gridData.widthHint = 28;
        this.sharpButton = new Button(composite2, 2);
        this.sharpButton.setLayoutData((Object)gridData);
        this.flatButton = new Button(composite2, 2);
        this.flatButton.setLayoutData((Object)gridData);
        this.sharpButton.setText("#");
        this.flatButton.setText("b");
        this.chordList = new org.eclipse.swt.widgets.List((Composite)this, 2048);
        this.chordList.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 1024, true, true));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(4, 1024, true, false));
        button.setText(TuxGuitar.getProperty("settings"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (new ChordSettingsDialog().open(ChordSelector.this.getShell())) {
                    new SyncThread(new Runnable(){

                        public void run() {
                            ChordSelector.this.showChord();
                            ChordSelector.this.getChordList().redraw();
                        }
                    }).start();
                }
            }
        });
        this.initChordWidgets();
        this.insertTonicNames(true);
        for (int i = 0; i < ChordDatabase.length(); ++i) {
            this.chordList.add(ChordDatabase.get(i).getName());
        }
        this.chordList.setSelection(0);
        String[] stringArray = this.getAlterationNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.alterationList.add(stringArray[i]);
        }
        this.alterationList.setSelection(0);
        String[] stringArray2 = this.getPlusMinus("");
        for (int i = 0; i < stringArray2.length; ++i) {
            this.plusMinusList.add(stringArray2[i]);
        }
        this.plusMinusList.setSelection(0);
        String[] stringArray3 = this.getPlusMinus("/5");
        for (int i = 0; i < stringArray3.length; ++i) {
            this._5List.add(stringArray3[i]);
        }
        this._5List.setSelection(0);
        String[] stringArray4 = this.getPlusMinus("/9");
        for (int i = 0; i < stringArray4.length; ++i) {
            this._9List.add(stringArray4[i]);
        }
        this._9List.setSelection(0);
        String[] stringArray5 = this.getPlusMinus("/11");
        for (int i = 0; i < stringArray5.length; ++i) {
            this._11List.add(stringArray5[i]);
        }
        this._11List.setSelection(0);
        this.tonicList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getRefresh() && ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null) {
                    ChordSelector.this.getBassCombo().select(ChordSelector.this.getTonicList().getSelectionIndex());
                    ChordSelector.this.showChord();
                }
            }
        });
        this.bassCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getRefresh() && ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null) {
                    ChordSelector.this.showChord();
                }
            }
        });
        this.chordList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null) {
                    ChordSelector.this.adjustWidgetAvailability();
                    if (ChordSelector.this.getRefresh()) {
                        ChordSelector.this.showChord();
                    }
                }
            }
        });
        this.alterationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null) {
                    ChordSelector.this.adjustWidgetAvailability();
                    if (ChordSelector.this.getRefresh()) {
                        ChordSelector.this.showChord();
                    }
                }
            }
        });
        this.addCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null) {
                    ChordSelector.this.adjustWidgetAvailability();
                    if (ChordSelector.this.getRefresh()) {
                        ChordSelector.this.showChord();
                    }
                }
            }
        });
        this._5List.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null && ChordSelector.this.getRefresh()) {
                    ChordSelector.this.showChord();
                }
            }
        });
        this._9List.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null && ChordSelector.this.getRefresh()) {
                    ChordSelector.this.showChord();
                }
            }
        });
        this._11List.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null && ChordSelector.this.getRefresh()) {
                    ChordSelector.this.showChord();
                }
            }
        });
        this.plusMinusList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordSelector.this.getDialog().getEditor() != null && ChordSelector.this.getDialog().getList() != null && ChordSelector.this.getRefresh()) {
                    ChordSelector.this.showChord();
                }
            }
        });
        this.sharpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordSelector.this.insertTonicNames(true);
            }
        });
        this.flatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordSelector.this.insertTonicNames(false);
            }
        });
        this.adjustWidgetAvailability();
    }

    protected void initChordWidgets() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)this.dialog.gridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.dialog.gridLayout(2, true, 0, 0));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)this.dialog.gridLayout(1, false, 0, 0));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.alterationList = new org.eclipse.swt.widgets.List(composite3, 2048);
        this.alterationList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.plusMinusList = new org.eclipse.swt.widgets.List(composite3, 2048);
        this.plusMinusList.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)this.dialog.gridLayout(1, false, 0, 0));
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        this._5List = new org.eclipse.swt.widgets.List(composite4, 2048);
        this._5List.setLayoutData((Object)new GridData(4, 4, true, true));
        this._9List = new org.eclipse.swt.widgets.List(composite4, 2048);
        this._9List.setLayoutData((Object)new GridData(4, 4, true, true));
        this._11List = new org.eclipse.swt.widgets.List(composite4, 2048);
        this._11List.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite5 = new Composite(composite, 0);
        composite5.setLayout((Layout)this.dialog.gridLayout(1, true, 0, 0));
        composite5.setLayoutData((Object)new GridData(4, 1024, true, true));
        this.addCheck = new Button(composite5, 16416);
        this.addCheck.setText("add");
        this.addCheck.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label = new Label(composite5, 258);
        label.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label2 = new Label(composite5, 16384);
        label2.setLayoutData((Object)new GridData(4, 1024, true, false));
        label2.setText(TuxGuitar.getProperty("chord.bass"));
        this.bassCombo = new Combo(composite5, 12);
        this.bassCombo.setLayoutData((Object)new GridData(4, 1024, true, false));
    }

    protected void insertTonicNames(boolean bl) {
        int n;
        String[] stringArray = KEY_NAMES[bl ? 0 : 1];
        this.flatButton.setSelection(!bl);
        this.sharpButton.setSelection(bl);
        int n2 = this.tonicList.getSelectionIndex();
        if (n2 == -1) {
            n2 = 0;
        }
        if ((n = this.bassCombo.getSelectionIndex()) == -1) {
            n = 0;
        }
        this.tonicList.removeAll();
        this.bassCombo.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            this.tonicList.add(stringArray[i]);
            this.bassCombo.add(stringArray[i]);
        }
        this.tonicList.setSelection(n2);
        this.bassCombo.select(n);
    }

    private String[] getPlusMinus(String string) {
        String[] stringArray = new String[]{" ", string + "+", string + "-"};
        return stringArray;
    }

    private String[] getAlterationNames() {
        String[] stringArray = new String[]{" ", "9", "11", "13"};
        return stringArray;
    }

    protected void showChord() {
        TuxGuitar.instance().loadCursor((Control)this.getShell(), 1);
        ChordCreatorListener chordCreatorListener = new ChordCreatorListener(){

            public void notifyChords(final ChordCreatorUtil chordCreatorUtil, final List list) {
                TuxGuitar.instance().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (chordCreatorUtil.isValidProcess() && !ChordSelector.this.getDialog().isDisposed()) {
                            ChordSelector.this.getDialog().getList().setChords(list);
                            TuxGuitar.instance().loadCursor((Control)ChordSelector.this.getShell(), 0);
                        }
                    }
                });
            }
        };
        ChordCreatorUtil.getChords(chordCreatorListener, this.tuning, this.chordList.getSelectionIndex(), this.alterationList.getSelectionIndex(), this.plusMinusList.getSelectionIndex(), this.addCheck.getSelection(), this._5List.getSelectionIndex(), this._9List.getSelectionIndex(), this._11List.getSelectionIndex(), this.bassCombo.getSelectionIndex(), this.tonicList.getSelectionIndex(), this.sharpButton.getSelection());
    }

    protected void updateWidget(org.eclipse.swt.widgets.List list, boolean bl) {
        list.setEnabled(bl);
        if (!bl) {
            list.setSelection(0);
        }
    }

    protected void updateWidget(Button button, boolean bl) {
        button.setEnabled(bl);
        if (!bl) {
            button.setSelection(false);
        }
    }

    public void adjustWidgets(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setRefresh(false);
        this.tonicList.setSelection(n);
        this.alterationList.setSelection(n3);
        this.bassCombo.select(n4);
        this.plusMinusList.setSelection(n5);
        this.addCheck.setSelection(n6 != 0);
        this._5List.setSelection(n7);
        this._9List.setSelection(n8);
        this._11List.setSelection(n9);
        this.chordList.setSelection(n2);
        this.adjustWidgetAvailability();
        this.setRefresh(true);
        this.showChord();
    }

    protected void adjustWidgetAvailability() {
        String string = ChordDatabase.get(this.getChordList().getSelectionIndex()).getName();
        if (string.equals("dim") || string.equals("dim7") || string.equals("aug") || string.equals("5")) {
            this.updateWidget(this.getAlterationList(), false);
            this.updateWidget(this.getAddCheck(), false);
            this.updateWidget(this.get_9List(), false);
            this.updateWidget(this.get_11List(), false);
            this.updateWidget(this.getPlusMinusList(), false);
            if (!string.equals("5")) {
                this.updateWidget(this.get_5List(), false);
            } else {
                this.updateWidget(this.get_5List(), true);
            }
        } else {
            this.updateWidget(this.getAlterationList(), true);
            this.updateWidget(this.get_5List(), true);
        }
        if (this.alterationList.isEnabled()) {
            int n = this.alterationList.getSelectionIndex();
            this.updateWidget(this.plusMinusList, n > 0);
            this.updateWidget(this.addCheck, n > 0);
            this.updateWidget(this._9List, n >= 2 && !this.addCheck.getSelection());
            this.updateWidget(this._11List, n >= 3 && !this.addCheck.getSelection());
        }
    }

    public boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public void setTuning(int[] nArray) {
        this.tuning = nArray;
    }

    public int[] getTuning() {
        return this.tuning;
    }

    protected ChordDialog getDialog() {
        return this.dialog;
    }

    protected org.eclipse.swt.widgets.List getTonicList() {
        return this.tonicList;
    }

    protected org.eclipse.swt.widgets.List getChordList() {
        return this.chordList;
    }

    protected org.eclipse.swt.widgets.List getAlterationList() {
        return this.alterationList;
    }

    protected Button getSharpButton() {
        return this.sharpButton;
    }

    protected Button getFlatButton() {
        return this.flatButton;
    }

    protected Combo getBassCombo() {
        return this.bassCombo;
    }

    protected Button getAddCheck() {
        return this.addCheck;
    }

    protected org.eclipse.swt.widgets.List getPlusMinusList() {
        return this.plusMinusList;
    }

    protected org.eclipse.swt.widgets.List get_5List() {
        return this._5List;
    }

    protected org.eclipse.swt.widgets.List get_9List() {
        return this._9List;
    }

    protected org.eclipse.swt.widgets.List get_11List() {
        return this._11List;
    }
}

