/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

public class ChordDatabase {
    private static final ChordInfo[] data = new ChordInfo[]{new ChordInfo("M", new int[]{1, 5, 8}), new ChordInfo("7", new int[]{1, 5, 8, 11}), new ChordInfo("maj7", new int[]{1, 5, 8, 12}), new ChordInfo("6", new int[]{1, 5, 8, 10}), new ChordInfo("m", new int[]{1, 4, 8}), new ChordInfo("m7", new int[]{1, 4, 8, 11}), new ChordInfo("m/maj7", new int[]{1, 4, 8, 12}), new ChordInfo("m6", new int[]{1, 4, 8, 10}), new ChordInfo("sus2", new int[]{1, 3, 8}), new ChordInfo("sus4", new int[]{1, 6, 8}), new ChordInfo("7sus2", new int[]{1, 3, 8, 11}), new ChordInfo("7sus4", new int[]{1, 6, 8, 11}), new ChordInfo("dim", new int[]{1, 4, 7}), new ChordInfo("dim7", new int[]{1, 4, 7, 10}), new ChordInfo("aug", new int[]{1, 5, 9}), new ChordInfo("5", new int[]{1, 8})};

    public static int length() {
        return data.length;
    }

    public static ChordInfo get(int n) {
        return data[n];
    }

    public static class ChordInfo {
        private String name;
        private int[] requiredNotes;

        public ChordInfo(String string, int[] nArray) {
            this.name = string;
            this.requiredNotes = nArray;
        }

        public String getName() {
            return this.name;
        }

        public int[] getRequiredNotes() {
            return this.requiredNotes;
        }

        public int[] cloneRequireds() {
            int[] nArray = new int[this.requiredNotes.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.requiredNotes[i];
            }
            return nArray;
        }
    }
}

