/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.transport;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.MidiTickUtil;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.song.models.TGMeasure;

public class TransportPlayAction
extends Action {
    public static final String NAME = "action.transport.play";

    public TransportPlayAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        if (!midiPlayer.isRunning()) {
            try {
                midiPlayer.getMode().reset();
                midiPlayer.play();
                this.playThread();
            }
            catch (MidiPlayerException midiPlayerException) {
                MessageDialog.errorMessage(midiPlayerException);
            }
        } else {
            TGMeasure tGMeasure = this.getSongManager().getTrackManager().getMeasureAt(this.getSongManager().getFirstTrack(), MidiTickUtil.getStart(midiPlayer.getTickPosition()));
            midiPlayer.pause();
            if (tGMeasure != null) {
                midiPlayer.setTickPosition(MidiTickUtil.getTick(tGMeasure.getStart()));
            }
            this.getEditor().getTablature().getCaret().goToTickPosition();
        }
        return 0;
    }

    protected void playThread() {
        final Display display = TuxGuitar.instance().getDisplay();
        final Runnable runnable = new Runnable(){

            public void run() {
                if (TuxGuitar.instance().getPlayer().isRunning()) {
                    TuxGuitar.instance().redrawPayingMode();
                }
            }
        };
        final Runnable runnable2 = new Runnable(){

            public void run() {
                TuxGuitar.instance().updateCache(true);
            }
        };
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (TuxGuitar.instance().getPlayer().isRunning()) {
                        if (display.isDisposed()) continue;
                        Display display2 = display;
                        synchronized (display2) {
                            display.syncExec(runnable);
                            display.wait(25L);
                        }
                    }
                    if (!display.isDisposed()) {
                        display.syncExec(runnable2);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }).start();
    }
}

