/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.system;

import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.marker.MarkerList;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.lock.TGSongLock;
import org.herac.tuxguitar.gui.table.TGTableViewer;
import org.herac.tuxguitar.gui.util.ConfirmDialog;

public class DisposeAction
extends Action {
    public static final String NAME = "action.system.dispose";

    public DisposeAction() {
        super(NAME, 1);
    }

    protected int execute(TypedEvent typedEvent) {
        if (typedEvent instanceof ShellEvent) {
            TuxGuitar.instance().getPlayer().reset();
            if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
                ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
                int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL, ConfirmDialog.BUTTON_YES);
                if (n == ConfirmDialog.STATUS_CANCEL) {
                    return 2;
                }
                if (n == ConfirmDialog.STATUS_YES) {
                    final String string = FileActionUtils.getFileName();
                    if (string == null) {
                        return 2;
                    }
                    TuxGuitar.instance().loadCursor(1);
                    new Thread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                FileActionUtils.save(string);
                                TuxGuitar.instance().loadCursor(0);
                                DisposeAction.this.exit();
                            }
                        }
                    }).start();
                    return 0;
                }
            }
            this.exit();
        }
        return 0;
    }

    protected void exit() {
        TGSongLock.lock();
        new SyncThread(new Runnable(){

            public void run() {
                DisposeAction.this.closeModules();
                DisposeAction.this.saveConfig();
                DisposeAction.this.dispose();
            }
        }).start();
    }

    protected void saveConfig() {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        tGConfigManager.setProperty("layout.mode", this.getEditor().getTablature().getViewLayout().getMode());
        tGConfigManager.setProperty("layout.style", this.getEditor().getTablature().getViewLayout().getStyle());
        tGConfigManager.setProperty("show.piano", !TuxGuitar.instance().getPianoEditor().isDisposed());
        tGConfigManager.setProperty("show.matrix", !TuxGuitar.instance().getMatrixEditor().isDisposed());
        tGConfigManager.setProperty("show.fretboard", TuxGuitar.instance().getFretBoardEditor().isVisible());
        tGConfigManager.setProperty("show.mixer", !TuxGuitar.instance().getMixer().isDisposed());
        tGConfigManager.setProperty("show.transport", !TuxGuitar.instance().getTransport().isDisposed());
        tGConfigManager.setProperty("show.markers", !MarkerList.instance().isDisposed());
        tGConfigManager.setProperty("window.maximized", TuxGuitar.instance().getShell().getMaximized());
        tGConfigManager.setProperty("window.width", TuxGuitar.instance().getShell().getClientArea().width);
        tGConfigManager.setProperty("window.height", TuxGuitar.instance().getShell().getClientArea().height);
        tGConfigManager.setProperty("editor.mouse.mode", this.getEditor().getTablature().getEditorKit().getMouseMode());
        tGConfigManager.setProperty("matrix.grids", TuxGuitar.instance().getMatrixEditor().getGrids());
        TuxGuitar.instance().getConfig().save();
    }

    protected void closeModules() {
        TuxGuitar.instance().getPlayer().close();
        TuxGuitar.instance().getPluginManager().closePLugins();
    }

    protected void dispose() {
        TGTableViewer.disposeColors();
        TuxGuitar.instance().getSongManager().clearSong();
        TuxGuitar.instance().getFretBoardEditor().dispose();
        TuxGuitar.instance().getTablatureEditor().getTablature().dispose();
        TuxGuitar.instance().getIconManager().disposeIcons();
        TuxGuitar.instance().getShell().dispose();
        TuxGuitar.instance().getDisplay().dispose();
    }
}

