/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;

public class ChangeTiedNoteAction
extends Action {
    public static final String NAME = "action.note.general.tied";

    public ChangeTiedNoteAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (caret.getSelectedNote() != null) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSongManager().getMeasureManager().changeTieNote(caret.getSelectedNote());
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        } else {
            TGNote tGNote = this.getSongManager().getFactory().newNote();
            tGNote.setValue(0);
            tGNote.setVelocity(caret.getVelocity());
            tGNote.setString(caret.getSelectedString().getNumber());
            tGNote.setTiedNote(true);
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            caret.getDuration().copy(tGDuration);
            this.setTiedNoteValue(tGNote, caret);
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSongManager().getMeasureManager().addNote(caret.getSelectedBeat(), tGNote, tGDuration);
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        }
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        return 0;
    }

    private void setTiedNoteValue(TGNote tGNote, Caret caret) {
        TGMeasure tGMeasure = caret.getMeasure();
        TGNote tGNote2 = null;
        while (tGMeasure != null) {
            tGNote2 = this.getSongManager().getMeasureManager().getPreviousNote(tGMeasure, caret.getPosition(), caret.getSelectedString().getNumber());
            if (tGNote2 != null) {
                tGNote.setValue(tGNote2.getValue());
                break;
            }
            tGMeasure = this.getSongManager().getTrackManager().getPrevMeasure(tGMeasure);
        }
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

