/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.lock.TGActionLock;
import org.herac.tuxguitar.gui.util.ConfirmDialog;

public class NewFileAction
extends Action {
    public static final String NAME = "action.file.new";

    public NewFileAction() {
        super(NAME, 13);
    }

    protected int execute(TypedEvent typedEvent) {
        if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
            int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL, ConfirmDialog.BUTTON_YES);
            if (n == ConfirmDialog.STATUS_CANCEL) {
                return 2;
            }
            if (n == ConfirmDialog.STATUS_YES) {
                final String string = FileActionUtils.getFileName();
                if (string == null) {
                    return 2;
                }
                TuxGuitar.instance().loadCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            FileActionUtils.save(string);
                            TuxGuitar.instance().loadCursor(0);
                            new SyncThread(new Runnable(){

                                public void run() {
                                    if (!TuxGuitar.isDisposed()) {
                                        NewFileAction.this.newSong();
                                    }
                                }
                            }).start();
                        }
                    }
                }).start();
                return 0;
            }
        }
        this.newSong();
        return 0;
    }

    protected void newSong() {
        TuxGuitar.instance().loadCursor(1);
        new Thread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    TuxGuitar.instance().newSong();
                    TuxGuitar.instance().loadCursor(0);
                    TGActionLock.unlock();
                }
            }
        }).start();
    }
}

