/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.effects.TremoloBarEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;

public class ChangeTremoloBarAction
extends Action {
    public static final String NAME = "action.note.effect.change-tremolo-bar";

    public ChangeTremoloBarAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGNote tGNote = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (tGNote != null) {
            this.changeTremoloBar(new TremoloBarEditor().show(this.getEditor().getTablature().getShell(), tGNote));
        }
        return 0;
    }

    private void changeTremoloBar(TGEffectTremoloBar tGEffectTremoloBar) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        this.getSongManager().getMeasureManager().changeTremoloBar(caret.getMeasure(), caret.getPosition(), caret.getSelectedString().getNumber(), tGEffectTremoloBar);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

