/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeInfo;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGSong;

public class ChangeInfoAction
extends Action {
    public static final String NAME = "action.composition.change-info";
    private static final int TEXT_WIDTH = 300;

    public ChangeInfoAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGSong tGSong = this.getSongManager().getSong();
        if (tGSong != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setLayoutData((Object)new GridData(4, 4, true, true));
            shell2.setText(TuxGuitar.getProperty("composition.properties"));
            Group group = new Group((Composite)shell2, 16);
            group.setLayout((Layout)this.makeGroupLayout(5));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.properties"));
            Label label = new Label((Composite)group, 0);
            label.setLayoutData((Object)this.makeLabelData());
            label.setText(TuxGuitar.getProperty("composition.name") + ":");
            final Text text = new Text((Composite)group, 2048);
            text.setLayoutData((Object)this.makeTextData());
            text.setText(tGSong.getName());
            Label label2 = new Label((Composite)group, 0);
            label2.setLayoutData((Object)this.makeLabelData());
            label2.setText(TuxGuitar.getProperty("composition.artist") + ":");
            final Text text2 = new Text((Composite)group, 2048);
            text2.setLayoutData((Object)this.makeTextData());
            text2.setText(tGSong.getArtist());
            Label label3 = new Label((Composite)group, 0);
            label3.setLayoutData((Object)this.makeLabelData());
            label3.setText(TuxGuitar.getProperty("composition.album") + ":");
            final Text text3 = new Text((Composite)group, 2048);
            text3.setLayoutData((Object)this.makeTextData());
            text3.setText(tGSong.getAlbum());
            Label label4 = new Label((Composite)group, 0);
            label4.setLayoutData((Object)this.makeLabelData());
            label4.setText(TuxGuitar.getProperty("composition.author") + ":");
            final Text text4 = new Text((Composite)group, 2048);
            text4.setLayoutData((Object)this.makeTextData());
            text4.setText(tGSong.getAuthor());
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(131072, 4, true, true));
            Button button = new Button(composite, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)this.getButtonData());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeInfoAction.this.setProperties(text.getText(), text2.getText(), text3.getText(), text4.getText());
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData((Object)this.getButtonData());
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridLayout makeGroupLayout(int n) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = n;
        gridLayout.marginBottom = n;
        gridLayout.marginLeft = n;
        gridLayout.marginRight = n;
        gridLayout.verticalSpacing = n;
        gridLayout.horizontalSpacing = n;
        return gridLayout;
    }

    private GridData makeTextData() {
        return new GridData(300, -1);
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, true, true);
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void setProperties(String string, String string2, String string3, String string4) {
        UndoableChangeInfo undoableChangeInfo = UndoableChangeInfo.startUndo();
        this.getSongManager().setProperties(string, string2, string3, string4);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        TuxGuitar.instance().showTitle();
        this.addUndoableEdit(undoableChangeInfo.endUndo());
    }
}

