/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class GTPInputStream
implements TGInputStreamBase {
    private int versionIndex;
    private String version;
    private String[] versions;
    private TGFactory factory;
    private InputStream stream;

    public GTPInputStream(String[] stringArray) {
        this.versions = stringArray;
    }

    public void init(TGFactory tGFactory, InputStream inputStream) {
        this.factory = tGFactory;
        this.stream = inputStream;
        this.version = null;
    }

    protected String getVersion() {
        return this.version;
    }

    protected int getVersionIndex() {
        return this.versionIndex;
    }

    protected TGFactory getFactory() {
        return this.factory;
    }

    public boolean isSupportedVersion(String string) {
        for (int i = 0; i < this.versions.length; ++i) {
            if (!string.equals(this.versions[i])) continue;
            this.versionIndex = i;
            return true;
        }
        return false;
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.getVersion());
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    protected void readVersion() {
        try {
            if (this.version == null) {
                this.version = this.readStringByte(30);
            }
        }
        catch (IOException iOException) {
            this.version = "NOT_SUPPORTED";
        }
    }

    protected int read() throws IOException {
        return this.stream.read();
    }

    protected int read(byte[] byArray) throws IOException {
        return this.stream.read(byArray);
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        return this.stream.read(byArray, n, n2);
    }

    protected void skip(int n) throws IOException {
        this.stream.read(new byte[n]);
    }

    protected int readUnsignedByte() throws IOException {
        return this.stream.read() & 0xFF;
    }

    protected byte readByte() throws IOException {
        return (byte)this.stream.read();
    }

    protected boolean readBoolean() throws IOException {
        return this.stream.read() == 1;
    }

    protected int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.stream.read(byArray);
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    protected long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.stream.read(byArray);
        return (long)(byArray[7] & 0xFF) << 56 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[0] & 0xFF);
    }

    protected String readString(int n, int n2) throws IOException {
        byte[] byArray = new byte[n > 0 ? n : n2];
        this.stream.read(byArray);
        return this.newString(byArray, n2 >= 0 ? n2 : n);
    }

    protected String readString(int n) throws IOException {
        return this.readString(n, n);
    }

    protected String readStringInteger() throws IOException {
        return this.readString(this.readInt());
    }

    protected String readStringByte(int n) throws IOException {
        return this.readString(n, this.readUnsignedByte());
    }

    protected String readStringByteSizeOfByte() throws IOException {
        return this.readStringByte(this.readUnsignedByte() - 1);
    }

    protected String readStringByteSizeOfInteger() throws IOException {
        return this.readStringByte(this.readInt() - 1);
    }

    private String newString(byte[] byArray, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }
}

