/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb;

import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.ptb.TGSongAdjuster;
import org.herac.tuxguitar.io.ptb.base.PTBar;
import org.herac.tuxguitar.io.ptb.base.PTBeat;
import org.herac.tuxguitar.io.ptb.base.PTComponent;
import org.herac.tuxguitar.io.ptb.base.PTGuitarIn;
import org.herac.tuxguitar.io.ptb.base.PTNote;
import org.herac.tuxguitar.io.ptb.base.PTPosition;
import org.herac.tuxguitar.io.ptb.base.PTSection;
import org.herac.tuxguitar.io.ptb.base.PTSong;
import org.herac.tuxguitar.io.ptb.base.PTSymbol;
import org.herac.tuxguitar.io.ptb.base.PTTempo;
import org.herac.tuxguitar.io.ptb.base.PTTrack;
import org.herac.tuxguitar.io.ptb.base.PTTrackInfo;
import org.herac.tuxguitar.io.ptb.helper.TrackHelper;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;

public class PTSongParser {
    private TGSongManager manager;
    private TrackHelper helper;

    public PTSongParser(TGFactory tGFactory) {
        this.manager = new TGSongManager(tGFactory);
        this.helper = new TrackHelper();
    }

    public TGSong parseSong(PTSong pTSong) {
        this.manager.setSong(this.manager.newSong());
        this.parseTrack(pTSong.getTrack1(), this.manager.getSong().countTracks());
        this.parseTrack(pTSong.getTrack2(), this.manager.getSong().countTracks() + 1);
        return new TGSongAdjuster(this.manager).process();
    }

    private void parseTrack(PTTrack pTTrack, int n) {
        this.helper.reset();
        long l = 1000L;
        for (int i = 0; i < pTTrack.getSections().size(); ++i) {
            PTSection pTSection = (PTSection)pTTrack.getSections().get(i);
            pTSection.orderPositions();
            this.helper.getStartHelper().init(pTSection.getNumber(), pTSection.getStaffs());
            this.helper.getStartHelper().initVoices(l);
            for (int j = 0; j < pTSection.getPositions().size(); ++j) {
                PTPosition pTPosition = (PTPosition)pTSection.getPositions().get(j);
                this.parsePosition(pTTrack, pTPosition, n);
            }
            l = this.helper.getStartHelper().getMaxStart();
        }
    }

    private void parsePosition(PTTrack pTTrack, PTPosition pTPosition, int n) {
        for (int i = 0; i < pTPosition.getComponents().size(); ++i) {
            PTComponent pTComponent = (PTComponent)pTPosition.getComponents().get(i);
            if (pTComponent instanceof PTBar) {
                this.parseBar((PTBar)pTComponent, n);
                continue;
            }
            if (pTComponent instanceof PTSymbol) {
                this.parseSymbol((PTSymbol)pTComponent, n);
                continue;
            }
            if (pTComponent instanceof PTGuitarIn) {
                this.parseGuitarIn(pTTrack, (PTGuitarIn)pTComponent, n);
                continue;
            }
            if (pTComponent instanceof PTTempo) {
                this.parseTempo((PTTempo)pTComponent);
                continue;
            }
            if (!(pTComponent instanceof PTBeat)) continue;
            this.parseBeat((PTBeat)pTComponent, n);
        }
    }

    private void parseBar(PTBar pTBar, int n) {
        this.helper.getStartHelper().initVoices(this.helper.getStartHelper().getMaxStart());
        if (pTBar.getRepeatClose() > 0 && !this.helper.getRepeatHelper().isRepeatAlternative()) {
            this.helper.getRepeatHelper().setRepeatEnd(this.helper.getStartHelper().getMaxStart());
            this.doRepeat(pTBar.getRepeatClose() - 1, n);
        }
        if (pTBar.isRepeatStart()) {
            this.helper.getRepeatHelper().reset();
            this.helper.getRepeatHelper().setRepeatStart(this.helper.getStartHelper().getMaxStart());
        }
    }

    private void parseSymbol(PTSymbol pTSymbol, int n) {
        if (pTSymbol.getEndNumber() == 1) {
            this.helper.getRepeatHelper().setRepeatAlternative(true);
            this.helper.getRepeatHelper().setRepeatEnd(this.helper.getStartHelper().getMaxStart());
        } else if (pTSymbol.getEndNumber() > 1 && this.helper.getRepeatHelper().isRepeatAlternative()) {
            this.doRepeat(1, n);
        }
    }

    private void parseGuitarIn(PTTrack pTTrack, PTGuitarIn pTGuitarIn, int n) {
        PTTrackInfo pTTrackInfo;
        if (!this.helper.getInfoHelper().isSetted(pTGuitarIn.getStaff()) && (pTTrackInfo = pTTrack.getInfo(pTGuitarIn.getTrackInfo())) != null) {
            TGTrack tGTrack = this.getTrack(n + pTGuitarIn.getStaff());
            tGTrack.setName(pTTrackInfo.getName());
            tGTrack.getChannel().setInstrument((short)pTTrackInfo.getInstrument());
            tGTrack.getChannel().setVolume((short)pTTrackInfo.getVolume());
            tGTrack.getChannel().setBalance((short)pTTrackInfo.getBalance());
            tGTrack.getStrings().clear();
            for (int i = 0; i < pTTrackInfo.getStrings().length; ++i) {
                TGString tGString = this.manager.getFactory().newString();
                tGString.setNumber(i + 1);
                tGString.setValue(pTTrackInfo.getStrings()[i]);
                tGTrack.getStrings().add(tGString);
            }
            this.helper.getInfoHelper().setStaff(pTGuitarIn.getStaff());
        }
    }

    private void parseTempo(PTTempo pTTempo) {
        TGMeasure tGMeasure = this.getMeasure(1, this.helper.getStartHelper().getMaxStart());
        tGMeasure.getTempo().setValue(pTTempo.getTempo());
        tGMeasure.getHeader().setTripletFeel(pTTempo.getTripletFeel());
    }

    private void parseBeat(PTBeat pTBeat, int n) {
        if (pTBeat.isGrace()) {
            return;
        }
        for (int i = 0; i < pTBeat.getMultiBarRest(); ++i) {
            TGBeat tGBeat = this.manager.getFactory().newBeat();
            tGBeat.setStart(this.helper.getStartHelper().getVoiceStart(pTBeat.getStaff(), pTBeat.getVoice()));
            tGBeat.getDuration().setValue(pTBeat.getDuration());
            tGBeat.getDuration().setDotted(pTBeat.isDotted());
            tGBeat.getDuration().setDoubleDotted(pTBeat.isDoubleDotted());
            tGBeat.getDuration().getTupleto().setTimes(pTBeat.getTimes());
            tGBeat.getDuration().getTupleto().setEnters(pTBeat.getEnters());
            TGMeasure tGMeasure = this.getMeasure(n + pTBeat.getStaff(), tGBeat.getStart());
            tGMeasure.addBeat(tGBeat);
            Iterator iterator = pTBeat.getNotes().iterator();
            while (iterator.hasNext()) {
                PTNote pTNote = (PTNote)iterator.next();
                TGNote tGNote = this.manager.getFactory().newNote();
                tGNote.setString(pTNote.getString());
                tGNote.setValue(pTNote.getValue());
                tGNote.setTiedNote(pTNote.isTied());
                tGNote.getEffect().setVibrato(pTBeat.isVibrato());
                tGNote.getEffect().setDeadNote(pTNote.isDead());
                tGNote.getEffect().setHammer(pTNote.isHammer());
                tGNote.getEffect().setSlide(pTNote.isSlide());
                tGNote.getEffect().setBend(this.makeBend(pTNote.getBend()));
                tGBeat.addNote(tGNote);
            }
            this.helper.getStartHelper().setVoiceStart(pTBeat.getStaff(), pTBeat.getVoice(), tGBeat.getStart() + tGBeat.getDuration().getTime());
        }
    }

    private void doRepeat(int n, int n2) {
        long l = this.helper.getRepeatHelper().getRepeatStart();
        long l2 = this.helper.getRepeatHelper().getRepeatEnd();
        if (n > 0 && l >= 1000L && l2 > l) {
            long l3 = this.helper.getStartHelper().getMaxStart();
            for (int i = n2 - 1; i < this.manager.getSong().countTracks(); ++i) {
                TGTrack tGTrack = this.manager.getSong().getTrack(i);
                List list = this.manager.getTrackManager().getMeasuresBetween(tGTrack, l, l2);
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < list.size(); ++k) {
                        TGMeasure tGMeasure = (TGMeasure)list.get(k);
                        for (int i2 = 0; i2 < tGMeasure.countBeats(); ++i2) {
                            TGBeat tGBeat = tGMeasure.getBeat(i2);
                            if (tGBeat.getStart() < l || tGBeat.getStart() >= l2) continue;
                            TGBeat tGBeat2 = tGBeat.clone(this.manager.getFactory());
                            tGBeat2.setStart(tGBeat2.getStart() + (l3 - l) * (long)(j + 1));
                            this.getMeasure(tGTrack.getNumber(), tGBeat2.getStart()).addBeat(tGBeat2);
                        }
                    }
                }
            }
            this.helper.getStartHelper().initVoices(this.helper.getStartHelper().getMaxStart() + (l2 - l) * (long)n);
            this.helper.getRepeatHelper().reset();
        }
    }

    private TGEffectBend makeBend(int n) {
        if (n >= 1 && n <= 8) {
            TGEffectBend tGEffectBend = this.manager.getFactory().newEffectBend();
            if (n == 1) {
                tGEffectBend.addPoint(0, 0);
                tGEffectBend.addPoint(6, 4);
                tGEffectBend.addPoint(12, 4);
            } else if (n == 2) {
                tGEffectBend.addPoint(0, 0);
                tGEffectBend.addPoint(3, 4);
                tGEffectBend.addPoint(6, 4);
                tGEffectBend.addPoint(9, 0);
                tGEffectBend.addPoint(12, 0);
            } else if (n == 3) {
                tGEffectBend.addPoint(0, 0);
                tGEffectBend.addPoint(6, 4);
                tGEffectBend.addPoint(12, 4);
            } else if (n == 4) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(12, 4);
            } else if (n == 5) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(4, 4);
                tGEffectBend.addPoint(8, 0);
                tGEffectBend.addPoint(12, 0);
            } else if (n == 6) {
                tGEffectBend.addPoint(0, 8);
                tGEffectBend.addPoint(12, 8);
            } else if (n == 7) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(4, 4);
                tGEffectBend.addPoint(8, 0);
                tGEffectBend.addPoint(12, 0);
            } else if (n == 8) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(4, 4);
                tGEffectBend.addPoint(8, 0);
                tGEffectBend.addPoint(12, 0);
            }
            return tGEffectBend;
        }
        return null;
    }

    private TGMeasure getMeasure(int n, long l) {
        TGMeasure tGMeasure = null;
        TGTrack tGTrack = this.getTrack(n);
        while ((tGMeasure = this.manager.getTrackManager().getMeasureAt(tGTrack, l)) == null) {
            this.manager.addNewMeasureBeforeEnd();
        }
        return tGMeasure;
    }

    private TGTrack getTrack(int n) {
        TGTrack tGTrack = null;
        while ((tGTrack = this.manager.getTrack(n)) == null) {
            tGTrack = this.manager.createTrack();
        }
        return tGTrack;
    }
}

