/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import org.herac.tuxguitar.player.base.MidiPort;
import org.herac.tuxguitar.player.base.MidiPortEmpty;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiReceiverImpl;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequenceLoader;

public class MidiSequencerImpl
implements MidiSequencer,
MidiSequenceLoader {
    private Sequencer sequencer;
    private MidiPort midiPort;

    public MidiSequencerImpl(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    protected Sequencer getSequencer() throws MidiUnavailableException {
        try {
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
                this.openReceiver();
            }
        }
        catch (Throwable throwable) {
            throw new MidiUnavailableException(throwable.getMessage());
        }
        return this.sequencer;
    }

    public void open() {
        try {
            this.getSequencer();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openReceiver() {
        try {
            Transmitter transmitter = this.getSequencer().getTransmitter();
            transmitter.setReceiver(new MidiReceiverImpl(this));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public MidiSequenceHandler createSequence(int n) {
        return new MidiSequenceHandlerImpl(this, n);
    }

    public MidiPort getMidiPort() {
        if (this.midiPort == null) {
            this.midiPort = new MidiPortEmpty();
        }
        return this.midiPort;
    }

    public void setMidiPort(MidiPort midiPort) {
        this.midiPort = midiPort;
    }

    public long getTickLength() {
        try {
            return this.getSequencer().getTickLength();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public long getTickPosition() {
        try {
            return this.getSequencer().getTickPosition();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public void setTickPosition(long l) {
        try {
            this.resetPicthBend();
            this.getSequencer().setTickPosition(l);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isRunning() {
        try {
            return this.getSequencer().isRunning();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setMute(int n, boolean bl) {
        try {
            this.getSequencer().setTrackMute(n, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSolo(int n, boolean bl) {
        try {
            this.getSequencer().setTrackSolo(n, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSequence(Sequence sequence) {
        try {
            this.getSequencer().setSequence(sequence);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void start() {
        try {
            this.getSequencer().start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.getSequencer().stop();
            this.getMidiPort().out().sendAllNotesOff();
            this.getMidiPort().out().sendSystemReset();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void resetPicthBend() {
        try {
            for (int i = 0; i < 16; ++i) {
                this.getMidiPort().out().sendPitchBend(i, 64);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getKey() {
        return this.sequencer.getDeviceInfo().getName();
    }

    public String getName() {
        return this.sequencer.getDeviceInfo().getName();
    }
}

