/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequenceLoader;
import org.herac.tuxguitar.player.impl.jsa.utils.MidiMessageUtils;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class MidiSequenceHandlerImpl
extends MidiSequenceHandler {
    private MidiSequenceLoader loader;
    private Sequence sequence;
    private Track[] midiTracks;

    public MidiSequenceHandlerImpl(MidiSequenceLoader midiSequenceLoader, int n) {
        super(n);
        this.loader = midiSequenceLoader;
        this.init();
    }

    private void init() {
        try {
            this.sequence = new Sequence(0.0f, 1000);
            this.midiTracks = new Track[this.getTracks()];
            for (int i = 0; i < this.midiTracks.length; ++i) {
                this.midiTracks[i] = this.sequence.createTrack();
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void addEvent(int n, MidiEvent midiEvent) {
        if (n >= 0 && n < this.midiTracks.length) {
            this.midiTracks[n].add(midiEvent);
        }
    }

    public void addControlChange(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.controlChange(n2, n3, n4), l));
    }

    public void addNoteOff(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.noteOff(n2, n3, n4), l));
    }

    public void addNoteOn(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.noteOn(n2, n3, n4), l));
    }

    public void addPitchBend(long l, int n, int n2, int n3) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.pitchBend(n2, n3), l));
    }

    public void addProgramChange(long l, int n, int n2, int n3) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.programChange(n2, n3), l));
    }

    public void addTempoInUSQ(long l, int n, int n2) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.tempoInUSQ(n2), l));
    }

    public void addTimeSignature(long l, int n, TGTimeSignature tGTimeSignature) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.timeSignature(tGTimeSignature), l));
    }

    public void notifyFinish() {
        this.loader.setSequence(this.getSequence());
    }
}

