/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.io.File;
import java.net.URL;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.TGFileUtils;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstaller;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerlistener;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;

public class SBInstallerGui
implements SBInstallerlistener {
    private static final String SB_PATH = TGFileUtils.PATH_USER_PLUGINS_CONFIG + File.separator + "tuxguitar-jsa";
    private Shell dialog;
    private Label progressLabel;
    private SBInstaller installer;

    public SBInstallerGui(URL uRL, MidiPortSynthesizer midiPortSynthesizer) {
        this.initInstaller(uRL, midiPortSynthesizer);
    }

    public void initInstaller(URL uRL, MidiPortSynthesizer midiPortSynthesizer) {
        File file = new File(SB_PATH);
        File file2 = new File(SB_PATH);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.installer = new SBInstaller(uRL, file, file2, midiPortSynthesizer, this);
    }

    public void open() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)67680);
        this.dialog.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label label = new Label(composite, 0);
        label.setImage(TuxGuitar.instance().getDisplay().getSystemImage(2));
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label label2 = new Label(composite, 64);
        label2.setLayoutData((Object)new GridData(4, 128, true, false));
        label2.setText(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.process.tip"));
        FontData[] fontDataArray = label2.getFont().getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setStyle(1);
        }
        final Font font = new Font((Device)label2.getDisplay(), fontDataArray);
        label2.setFont(font);
        label2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                font.dispose();
            }
        });
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        ProgressBar progressBar = new ProgressBar(composite2, 2);
        progressBar.setLayoutData((Object)new GridData(4, 128, true, false));
        this.progressLabel = new Label(composite2, 64);
        this.progressLabel.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite composite3 = new Composite((Composite)this.dialog, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(131072, 1024, true, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite3, 8);
        button.setText(TuxGuitar.getProperty((String)"cancel"));
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SBInstallerGui.this.getInstaller().setCancelled(true);
                SBInstallerGui.this.getDialog().dispose();
            }
        });
        this.process();
        DialogUtils.openDialog((Shell)this.dialog, (int)3);
    }

    private void process() {
        new Thread(new Runnable(){

            public void run() {
                if (!SBInstallerGui.this.isDisposed()) {
                    SBInstallerGui.this.getInstaller().process();
                }
            }
        }).start();
    }

    public void notifyProcess(final String string) {
        if (!this.isDisposed()) {
            TuxGuitar.instance().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getProgressLabel().setText(string);
                    }
                }
            });
        }
    }

    public void notifyFinish() {
        if (!this.isDisposed()) {
            TuxGuitar.instance().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getDialog().dispose();
                    }
                }
            });
        }
    }

    public void notifyFailed(final Throwable throwable) {
        if (!this.isDisposed()) {
            TuxGuitar.instance().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getDialog().dispose();
                        MessageDialog.errorMessage((Throwable)throwable);
                    }
                }
            });
        }
    }

    public boolean isDisposed() {
        return TuxGuitar.isDisposed() || this.getDialog().isDisposed();
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public Label getProgressLabel() {
        return this.progressLabel;
    }

    public SBInstaller getInstaller() {
        return this.installer;
    }
}

