/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    IDataObject iDataObject;
    COMObject iDropTarget;
    int refCount;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String DROPTARGETID = "DropTarget";
    static /* synthetic */ Class class$0;

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.createCOMInterfaces();
        this.AddRef();
        if (COM.CoLockObjectExternal(this.iDropTarget.getAddress(), true, true) != 0) {
            DND.error(2001);
        }
        if (COM.RegisterDragDrop(control.handle, this.iDropTarget.getAddress()) != 0) {
            DND.error(2001);
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    void createCOMInterfaces() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 5;
        nArray[4] = 4;
        nArray[6] = 5;
        this.iDropTarget = new COMObject(nArray){

            public int method0(int[] nArray) {
                return DropTarget.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return DropTarget.this.AddRef();
            }

            public int method2(int[] nArray) {
                return DropTarget.this.Release();
            }

            public int method3(int[] nArray) {
                return DropTarget.this.DragEnter(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method4(int[] nArray) {
                return DropTarget.this.DragOver(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method5(int[] nArray) {
                return DropTarget.this.DragLeave();
            }

            public int method6(int[] nArray) {
                return DropTarget.this.Drop(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.iDropTarget != null) {
            this.iDropTarget.dispose();
        }
        this.iDropTarget = null;
    }

    int DragEnter(int n, int n2, int n3, int n4, int n5) {
        this.selectedDataType = null;
        this.selectedOperation = 0;
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, n, n2, n3, n4, n5)) {
            OS.MoveMemory(n5, new int[1], 4);
            return 1;
        }
        this.iDataObject = new IDataObject(n);
        this.iDataObject.AddRef();
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.notifyListeners(2002, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n6 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        int n7 = 0;
        while (n7 < transferDataArray.length) {
            if (TransferData.sameType(transferDataArray[n7], dNDEvent.dataType)) {
                this.selectedDataType = transferDataArray[n7];
                break;
            }
            ++n7;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n5, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int DragLeave() {
        this.keyOperation = -1;
        if (this.iDataObject == null) {
            return 1;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        this.iDataObject.Release();
        this.iDataObject = null;
        return 0;
    }

    int DragOver(int n, int n2, int n3, int n4) {
        if (this.iDataObject == null) {
            return 1;
        }
        int n5 = this.keyOperation;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, this.iDataObject.getAddress(), n, n2, n3, n4)) {
            this.keyOperation = -1;
            OS.MoveMemory(n4, new int[1], 4);
            return 1;
        }
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (this.keyOperation == n5) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.notifyListeners(dNDEvent.type, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n6 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        int n7 = 0;
        while (n7 < transferDataArray.length) {
            if (TransferData.sameType(transferDataArray[n7], dNDEvent.dataType)) {
                this.selectedDataType = transferDataArray[n7];
                break;
            }
            ++n7;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n4, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int Drop(int n, int n2, int n3, int n4, int n5) {
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n3, n4);
        }
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, n, n2, n3, n4, n5)) {
            this.keyOperation = -1;
            OS.MoveMemory(n5, new int[1], 4);
            return 1;
        }
        this.keyOperation = -1;
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.refresh();
        this.selectedDataType = null;
        int n7 = 0;
        while (n7 < transferDataArray.length) {
            if (TransferData.sameType(transferDataArray[n7], dNDEvent.dataType)) {
                this.selectedDataType = transferDataArray[n7];
                break;
            }
            ++n7;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            OS.MoveMemory(n5, new int[1], 4);
            return 0;
        }
        Object object = null;
        int n8 = 0;
        while (n8 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[n8];
            if (transfer != null && transfer.isSupportedType(this.selectedDataType)) {
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++n8;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.data = object;
        OS.ImageList_DragShowNolock(false);
        try {
            this.notifyListeners(2006, dNDEvent);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            OS.ImageList_DragShowNolock(true);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        OS.ImageList_DragShowNolock(true);
        this.refresh();
        this.selectedOperation = 0;
        if ((n6 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n5, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int n) {
        boolean bl;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = bl = (n & 0x20) != 0;
        if (bl) {
            if (bl2 || bl3) {
                return 16;
            }
            return 4;
        }
        if (bl2 && bl3) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        COM.RevokeDragDrop(this.control.handle);
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DROPTARGETID, null);
        this.transferAgents = null;
        this.control = null;
        COM.CoLockObjectExternal(this.iDropTarget.getAddress(), false, true);
        this.Release();
        COM.CoFreeUnusedLibraries();
    }

    int opToOs(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    int osToOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDropTarget)) {
            OS.MoveMemory(n2, new int[]{this.iDropTarget.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(n2, new int[1], 4);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    void refresh() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        int n = this.control.handle;
        RECT rECT = new RECT();
        if (OS.GetUpdateRect(n, rECT, false)) {
            OS.ImageList_DragShowNolock(false);
            OS.RedrawWindow(n, rECT, 0, 257);
            OS.ImageList_DragShowNolock(true);
        }
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setEventData(DNDEvent dNDEvent, int n, int n2, int n3, int n4, int n5) {
        IDataObject iDataObject;
        TransferData[] transferDataArray;
        int n6;
        int[] nArray;
        block22: {
            block21: {
                if (n == 0 || n5 == 0) {
                    return false;
                }
                int n7 = this.getStyle();
                nArray = new int[1];
                OS.MoveMemory(nArray, n5, 4);
                nArray[0] = this.osToOp(nArray[0]) & n7;
                if (nArray[0] == 0) {
                    return false;
                }
                this.keyOperation = n6 = this.getOperationFromKeyState(n2);
                if (n6 == 16) {
                    if ((n7 & 0x10) == 0) {
                        n6 = (nArray[0] & 2) != 0 ? 2 : 0;
                    }
                } else if ((n6 & nArray[0]) == 0) {
                    n6 = 0;
                }
                transferDataArray = new TransferData[]{};
                iDataObject = new IDataObject(n);
                iDataObject.AddRef();
                try {
                    int[] nArray2 = new int[1];
                    if (iDataObject.EnumFormatEtc(1, nArray2) != 0) {
                        Object var24_13 = null;
                        break block21;
                    }
                    IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(nArray2[0]);
                    try {
                        int n8 = OS.GlobalAlloc(64, FORMATETC.sizeof);
                        try {
                            int[] nArray3 = new int[1];
                            iEnumFORMATETC.Reset();
                            block9: while (iEnumFORMATETC.Next(1, n8, nArray3) == 0 && nArray3[0] == 1) {
                                TransferData transferData = new TransferData();
                                transferData.formatetc = new FORMATETC();
                                COM.MoveMemory(transferData.formatetc, n8, FORMATETC.sizeof);
                                transferData.type = transferData.formatetc.cfFormat;
                                transferData.pIDataObject = n;
                                int n9 = 0;
                                while (n9 < this.transferAgents.length) {
                                    Transfer transfer = this.transferAgents[n9];
                                    if (transfer != null && transfer.isSupportedType(transferData)) {
                                        TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                                        System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                                        transferDataArray2[transferDataArray.length] = transferData;
                                        transferDataArray = transferDataArray2;
                                        continue block9;
                                    }
                                    ++n9;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var20_24 = null;
                            OS.GlobalFree(n8);
                            throw throwable;
                        }
                        {
                            Object var20_25 = null;
                            OS.GlobalFree(n8);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_27 = null;
                        iEnumFORMATETC.Release();
                        throw throwable;
                    }
                    {
                        Object var22_28 = null;
                        iEnumFORMATETC.Release();
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    Object var24_14 = null;
                    iDataObject.Release();
                    throw throwable;
                }
            }
            iDataObject.Release();
            return false;
        }
        Object var24_15 = null;
        iDataObject.Release();
        if (transferDataArray.length == 0) {
            return false;
        }
        dNDEvent.widget = this;
        dNDEvent.x = n3;
        dNDEvent.y = n4;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n3, n4);
        }
        dNDEvent.operations = nArray[0];
        dNDEvent.detail = n6;
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
    }
}

