/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.io.IOException;
import java.io.OutputStream;
import org.herac.tuxguitar.io.midi.MidiFileWriter;
import org.herac.tuxguitar.io.midi.MidiMessageUtils;
import org.herac.tuxguitar.io.midi.base.MidiEvent;
import org.herac.tuxguitar.io.midi.base.MidiSequence;
import org.herac.tuxguitar.io.midi.base.MidiTrack;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class MidiSequenceHandlerImpl
extends MidiSequenceHandler {
    private OutputStream stream;
    private MidiSequence sequence;

    public MidiSequenceHandlerImpl(int n, OutputStream outputStream) {
        super(n);
        this.stream = outputStream;
        this.init();
    }

    private void init() {
        this.sequence = new MidiSequence(0.0f, 1000);
        for (int i = 0; i < this.getTracks(); ++i) {
            this.sequence.addTrack(new MidiTrack());
        }
    }

    public MidiSequence getSequence() {
        return this.sequence;
    }

    public void addEvent(int n, MidiEvent midiEvent) {
        if (n >= 0 && n < this.getSequence().countTracks()) {
            this.getSequence().getTrack(n).add(midiEvent);
        }
    }

    public void addControlChange(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.controlChange(n2, n3, n4), l));
    }

    public void addNoteOff(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.noteOff(n2, n3, n4), l));
    }

    public void addNoteOn(long l, int n, int n2, int n3, int n4) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.noteOn(n2, n3, n4), l));
    }

    public void addPitchBend(long l, int n, int n2, int n3) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.pitchBend(n2, n3), l));
    }

    public void addProgramChange(long l, int n, int n2, int n3) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.programChange(n2, n3), l));
    }

    public void addTempoInUSQ(long l, int n, int n2) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.tempoInUSQ(n2), l));
    }

    public void addTimeSignature(long l, int n, TGTimeSignature tGTimeSignature) {
        this.addEvent(n, new MidiEvent(MidiMessageUtils.timeSignature(tGTimeSignature), l));
    }

    public void notifyFinish() {
        try {
            this.getSequence().finish();
            new MidiFileWriter().write(this.getSequence(), 1, this.stream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

