/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class RemoveLaunchApplication
extends AbstractTool {
    static {
        RemoveLaunchApplication.addVersion("$Id: RemoveLaunchApplication.java,v 1.4 2005/11/29 21:05:02 blowagie Exp $");
    }

    public RemoveLaunchApplication() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file from which you want to remove Launch Application actions", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the cleaned up version of the original PDF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Remove Launch Applications", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Remove Launch Applications OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n = 1;
            while (n < pdfReader.getXrefSize()) {
                PdfDictionary pdfDictionary;
                PdfObject pdfObject = pdfReader.getPdfObject(n);
                if (pdfObject instanceof PdfDictionary && (pdfObject = (pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.A)) != null) {
                    PdfDictionary pdfDictionary2;
                    if (pdfObject instanceof PdfDictionary) {
                        pdfDictionary2 = (PdfDictionary)pdfObject;
                    } else {
                        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                        pdfDictionary2 = (PdfDictionary)pdfReader.getPdfObject(pRIndirectReference.getNumber());
                    }
                    PdfName pdfName = (PdfName)pdfDictionary2.get(PdfName.S);
                    if (PdfName.LAUNCH.equals(pdfName)) {
                        if (pdfDictionary2.get(PdfName.F) != null) {
                            System.out.println("Removed: " + pdfDictionary2.get(PdfName.F));
                            pdfDictionary2.remove(PdfName.F);
                        }
                        if (pdfDictionary2.get(PdfName.WIN) != null) {
                            System.out.println("Removed: " + pdfDictionary2.get(PdfName.WIN));
                            pdfDictionary2.remove(PdfName.WIN);
                        }
                        pdfDictionary2.put(PdfName.S, PdfName.JAVASCRIPT);
                        pdfDictionary2.put(PdfName.JS, new PdfString("app.alert('Launch Application Action removed by iText');\r"));
                    }
                }
                ++n;
            }
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(file2));
            pdfStamper.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        RemoveLaunchApplication removeLaunchApplication = new RemoveLaunchApplication();
        if (stringArray.length < 2) {
            System.err.println(removeLaunchApplication.getUsage());
        }
        removeLaunchApplication.setArguments(stringArray);
        removeLaunchApplication.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

