/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.headerfooter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfPageNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooter
extends HeaderFooter
implements RtfBasicElement {
    public static final int TYPE_HEADER = 1;
    public static final int TYPE_FOOTER = 2;
    public static final int DISPLAY_FIRST_PAGE = 0;
    public static final int DISPLAY_ALL_PAGES = 1;
    public static final int DISPLAY_LEFT_PAGES = 2;
    public static final int DISPLAY_RIGHT_PAGES = 4;
    private static final byte[] HEADER_ALL = "\\header".getBytes();
    private static final byte[] HEADER_FIRST = "\\headerf".getBytes();
    private static final byte[] HEADER_LEFT = "\\headerl".getBytes();
    private static final byte[] HEADER_RIGHT = "\\headerr".getBytes();
    private static final byte[] FOOTER_ALL = "\\footer".getBytes();
    private static final byte[] FOOTER_FIRST = "\\footerf".getBytes();
    private static final byte[] FOOTER_LEFT = "\\footerl".getBytes();
    private static final byte[] FOOTER_RIGHT = "\\footerr".getBytes();
    private RtfDocument document = null;
    private Object[] content = null;
    private int type = 1;
    private int displayAt = 1;

    protected RtfHeaderFooter(RtfDocument rtfDocument, HeaderFooter headerFooter, int n, int n2) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.type = n;
        this.displayAt = n2;
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            paragraph.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            paragraph.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            paragraph.add(headerFooter.getAfter());
        }
        try {
            this.content = new Object[1];
            if (this.document != null) {
                this.content[0] = this.document.getMapper().mapElement(paragraph);
                ((RtfBasicElement)this.content[0]).setInHeader(true);
            } else {
                this.content[0] = paragraph;
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    protected RtfHeaderFooter(RtfDocument rtfDocument, RtfHeaderFooter rtfHeaderFooter, int n) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.content = rtfHeaderFooter.getContent();
        this.displayAt = n;
        int n2 = 0;
        while (n2 < this.content.length) {
            if (this.content[n2] instanceof Element) {
                try {
                    this.content[n2] = this.document.getMapper().mapElement((Element)this.content[n2]);
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
            }
            if (this.content[n2] instanceof RtfBasicElement) {
                ((RtfBasicElement)this.content[n2]).setInHeader(true);
            }
            ++n2;
        }
    }

    protected RtfHeaderFooter(RtfDocument rtfDocument, HeaderFooter headerFooter) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            paragraph.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            paragraph.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            paragraph.add(headerFooter.getAfter());
        }
        try {
            this.content = new Object[1];
            this.content[0] = rtfDocument.getMapper().mapElement(paragraph);
            ((RtfBasicElement)this.content[0]).setInHeader(true);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public RtfHeaderFooter(Element element) {
        this(new Element[]{element});
    }

    public RtfHeaderFooter(Element[] elementArray) {
        super(new Phrase(""), false);
        this.content = new Object[elementArray.length];
        int n = 0;
        while (n < elementArray.length) {
            this.content[n] = elementArray[n];
            ++n;
        }
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        if (this.document != null) {
            int n = 0;
            while (n < this.content.length) {
                try {
                    if (this.content[n] instanceof Element) {
                        this.content[n] = this.document.getMapper().mapElement((Element)this.content[n]);
                        ((RtfBasicElement)this.content[n]).setInHeader(true);
                    } else if (this.content[n] instanceof RtfBasicElement) {
                        ((RtfBasicElement)this.content[n]).setRtfDocument(this.document);
                        ((RtfBasicElement)this.content[n]).setInHeader(true);
                    }
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
                ++n;
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            if (this.type == 1) {
                if (this.displayAt == 1) {
                    byteArrayOutputStream.write(HEADER_ALL);
                } else if (this.displayAt == 0) {
                    byteArrayOutputStream.write(HEADER_FIRST);
                } else if (this.displayAt == 2) {
                    byteArrayOutputStream.write(HEADER_LEFT);
                } else if (this.displayAt == 4) {
                    byteArrayOutputStream.write(HEADER_RIGHT);
                }
            } else if (this.displayAt == 1) {
                byteArrayOutputStream.write(FOOTER_ALL);
            } else if (this.displayAt == 0) {
                byteArrayOutputStream.write(FOOTER_FIRST);
            } else if (this.displayAt == 2) {
                byteArrayOutputStream.write(FOOTER_LEFT);
            } else if (this.displayAt == 4) {
                byteArrayOutputStream.write(FOOTER_RIGHT);
            }
            byteArrayOutputStream.write(DELIMITER);
            int n = 0;
            while (n < this.content.length) {
                if (this.content[n] instanceof RtfBasicElement) {
                    byteArrayOutputStream.write(((RtfBasicElement)this.content[n]).write());
                }
                ++n;
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setDisplayAt(int n) {
        this.displayAt = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    private Object[] getContent() {
        return this.content;
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
    }

    public void setAlignment(int n) {
        super.setAlignment(n);
        int n2 = 0;
        while (n2 < this.content.length) {
            if (this.content[n2] instanceof Paragraph) {
                ((Paragraph)this.content[n2]).setAlignment(n);
            } else if (this.content[n2] instanceof Table) {
                ((Table)this.content[n2]).setAlignment(n);
            } else if (this.content[n2] instanceof Image) {
                ((Image)this.content[n2]).setAlignment(n);
            }
            ++n2;
        }
    }
}

