/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.herac.tuxguitar.util.TGClassLoader;

public class TGServiceReader {
    private static final String SERVICE_PATH = new String("META-INF/services/");

    public static Iterator lookupProviders(Class clazz) {
        return TGServiceReader.lookupProviders(clazz, TGClassLoader.instance().getClassLoader());
    }

    public static Iterator lookupProviders(Class clazz, ClassLoader classLoader) {
        try {
            if (clazz == null || classLoader == null) {
                throw new IllegalArgumentException();
            }
            return new IteratorImpl(clazz, classLoader, classLoader.getResources(SERVICE_PATH + clazz.getName()));
        }
        catch (IOException iOException) {
            return Collections.EMPTY_LIST.iterator();
        }
    }

    private static final class IteratorImpl
    implements Iterator {
        private Class spi;
        private ClassLoader loader;
        private Enumeration urls;
        private Iterator iterator;

        public IteratorImpl(Class clazz, ClassLoader classLoader, Enumeration enumeration) {
            this.spi = clazz;
            this.loader = classLoader;
            this.urls = enumeration;
            this.initialize();
        }

        private void initialize() {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (this.urls.hasMoreElements()) {
                URL uRL = (URL)this.urls.nextElement();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        String string2 = this.uncommentLine(string).trim();
                        if (string2 == null || string2.length() <= 0) continue;
                        arrayList.add(string2);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.iterator = arrayList.iterator();
        }

        private String uncommentLine(String string) {
            int n = string.indexOf(35);
            if (n >= 0) {
                return string.substring(0, n);
            }
            return string;
        }

        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object obj = this.loader.loadClass((String)this.iterator.next()).newInstance();
                if (this.spi.isInstance(obj)) {
                    return obj;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

