/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTrack;

public abstract class TGSong {
    public static final int MAX_VOLUME = 10;
    private String name = new String();
    private String interpret = new String();
    private String album = new String();
    private String author = new String();
    private List tracks = new ArrayList();
    private List measureHeaders = new ArrayList();
    private int volume = 10;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String string) {
        this.album = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getInterpret() {
        return this.interpret;
    }

    public void setInterpret(String string) {
        this.interpret = string;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    public int countMeasureHeaders() {
        return this.measureHeaders.size();
    }

    public void addMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        this.addMeasureHeader(this.countMeasureHeaders(), tGMeasureHeader);
    }

    public void addMeasureHeader(int n, TGMeasureHeader tGMeasureHeader) {
        tGMeasureHeader.setSong(this);
        this.measureHeaders.add(n, tGMeasureHeader);
    }

    public void removeMeasureHeader(int n) {
        this.measureHeaders.remove(n);
    }

    public void removeMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        this.measureHeaders.remove(tGMeasureHeader);
    }

    public TGMeasureHeader getMeasureHeader(int n) {
        return (TGMeasureHeader)this.measureHeaders.get(n);
    }

    public Iterator getMeasureHeaders() {
        return this.measureHeaders.iterator();
    }

    public int countTracks() {
        return this.tracks.size();
    }

    public void addTrack(TGTrack tGTrack) {
        this.addTrack(this.countTracks(), tGTrack);
    }

    public void addTrack(int n, TGTrack tGTrack) {
        tGTrack.setSong(this);
        this.tracks.add(n, tGTrack);
    }

    public void moveTrack(int n, TGTrack tGTrack) {
        this.tracks.remove(tGTrack);
        this.tracks.add(n, tGTrack);
    }

    public void removeTrack(TGTrack tGTrack) {
        this.tracks.remove(tGTrack);
        tGTrack.clear();
    }

    public TGTrack getTrack(int n) {
        return (TGTrack)this.tracks.get(n);
    }

    public Iterator getTracks() {
        return this.tracks.iterator();
    }

    public boolean isEmpty() {
        return this.countMeasureHeaders() == 0 || this.countTracks() == 0;
    }

    public void clear() {
        Iterator iterator = this.getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            tGTrack.clear();
        }
    }

    public TGSong clone(TGFactory tGFactory) {
        TGSong tGSong = tGFactory.newSong();
        this.copy(tGFactory, tGSong);
        return tGSong;
    }

    public void copy(TGFactory tGFactory, TGSong tGSong) {
        Object object;
        tGSong.setName(this.getName());
        tGSong.setInterpret(this.getInterpret());
        tGSong.setAlbum(this.getAlbum());
        tGSong.setAuthor(this.getAuthor());
        tGSong.setVolume(this.getVolume());
        Iterator iterator = this.getMeasureHeaders();
        while (iterator.hasNext()) {
            object = (TGMeasureHeader)iterator.next();
            tGSong.addMeasureHeader(((TGMeasureHeader)object).clone(tGFactory));
        }
        object = this.getTracks();
        while (object.hasNext()) {
            TGTrack tGTrack = (TGTrack)object.next();
            tGSong.addTrack(tGTrack.clone(tGFactory, tGSong));
        }
    }
}

