/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;

public abstract class TGMeasure {
    public static final int CLEF_TREBLE = 1;
    public static final int CLEF_BASS = 2;
    public static final int CLEF_TENOR = 3;
    public static final int CLEF_ALTO = 4;
    private TGMeasureHeader header;
    private TGTrack track;
    private int clef;
    private int keySignature;
    private List beats;

    public TGMeasure(TGMeasureHeader tGMeasureHeader) {
        this.header = tGMeasureHeader;
        this.clef = 1;
        this.keySignature = 0;
        this.beats = new ArrayList();
    }

    public TGTrack getTrack() {
        return this.track;
    }

    public void setTrack(TGTrack tGTrack) {
        this.track = tGTrack;
    }

    public int getClef() {
        return this.clef;
    }

    public void setClef(int n) {
        this.clef = n;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int n) {
        this.keySignature = n;
    }

    public List getBeats() {
        return this.beats;
    }

    public void addBeat(TGBeat tGBeat) {
        tGBeat.setMeasure(this);
        this.beats.add(tGBeat);
    }

    public void moveBeat(int n, TGBeat tGBeat) {
        this.beats.remove(tGBeat);
        this.beats.add(n, tGBeat);
    }

    public void removeBeat(TGBeat tGBeat) {
        this.beats.remove(tGBeat);
    }

    public TGBeat getBeat(int n) {
        if (n >= 0 && n < this.countBeats()) {
            return (TGBeat)this.beats.get(n);
        }
        return null;
    }

    public int countBeats() {
        return this.beats.size();
    }

    public TGMeasureHeader getHeader() {
        return this.header;
    }

    public void setHeader(TGMeasureHeader tGMeasureHeader) {
        this.header = tGMeasureHeader;
    }

    public int getNumber() {
        return this.header.getNumber();
    }

    public int getRepeatClose() {
        return this.header.getRepeatClose();
    }

    public long getStart() {
        return this.header.getStart();
    }

    public TGTempo getTempo() {
        return this.header.getTempo();
    }

    public TGTimeSignature getTimeSignature() {
        return this.header.getTimeSignature();
    }

    public boolean isRepeatOpen() {
        return this.header.isRepeatOpen();
    }

    public int getTripletFeel() {
        return this.header.getTripletFeel();
    }

    public long getLength() {
        return this.header.getLength();
    }

    public boolean hasMarker() {
        return this.header.hasMarker();
    }

    public TGMarker getMarker() {
        return this.header.getMarker();
    }

    public void makeEqual(TGMeasure tGMeasure) {
        this.clef = tGMeasure.getClef();
        this.keySignature = tGMeasure.getKeySignature();
        this.beats.clear();
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            this.addBeat(tGBeat);
        }
    }

    public TGMeasure clone(TGFactory tGFactory, TGMeasureHeader tGMeasureHeader) {
        TGMeasure tGMeasure = tGFactory.newMeasure(tGMeasureHeader);
        tGMeasure.setClef(this.getClef());
        tGMeasure.setKeySignature(this.getKeySignature());
        for (int i = 0; i < this.countBeats(); ++i) {
            TGBeat tGBeat = (TGBeat)this.beats.get(i);
            tGMeasure.addBeat(tGBeat.clone(tGFactory));
        }
        return tGMeasure;
    }
}

