/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGTrackManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGSongManager {
    public static final short MAX_CHANNELS = 16;
    private TGFactory factory;
    private TGSong song;
    private TGTrackManager trackManager;
    private TGMeasureManager measureManager;

    public TGSongManager() {
        this(new TGFactory());
    }

    public TGSongManager(TGFactory tGFactory) {
        this.factory = tGFactory;
    }

    public TGFactory getFactory() {
        return this.factory;
    }

    public void setFactory(TGFactory tGFactory) {
        this.factory = tGFactory;
    }

    public TGTrackManager getTrackManager() {
        if (this.trackManager == null) {
            this.trackManager = new TGTrackManager(this);
        }
        return this.trackManager;
    }

    public TGMeasureManager getMeasureManager() {
        if (this.measureManager == null) {
            this.measureManager = new TGMeasureManager(this);
        }
        return this.measureManager;
    }

    public void setSongName(String string) {
        this.getSong().setName(string);
    }

    public TGSong getSong() {
        return this.song;
    }

    public void clearSong() {
        if (this.getSong() != null) {
            this.getSong().clear();
        }
    }

    public void setSong(TGSong tGSong) {
        if (tGSong != null) {
            this.clearSong();
            this.song = tGSong;
        }
    }

    public void setProperties(String string, String string2, String string3, String string4) {
        this.getSong().setName(string);
        this.getSong().setInterpret(string2);
        this.getSong().setAlbum(string3);
        this.getSong().setAuthor(string4);
    }

    public void addTrack(TGTrack tGTrack) {
        this.orderTracks();
        int n = -1;
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack2 = this.getSong().getTrack(i);
            if (n == -1 && tGTrack2.getNumber() == tGTrack.getNumber()) {
                n = i;
            }
            if (n < 0) continue;
            tGTrack2.setNumber(tGTrack2.getNumber() + 1);
        }
        if (n < 0) {
            n = this.getSong().countTracks();
        }
        this.getSong().addTrack(n, tGTrack);
    }

    public void removeTrack(int n) {
        int n2 = n;
        TGTrack tGTrack = null;
        this.orderTracks();
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack2 = (TGTrack)iterator.next();
            if (tGTrack == null && tGTrack2.getNumber() == n2) {
                tGTrack = tGTrack2;
                continue;
            }
            if (tGTrack2.getNumber() != n2 + 1) continue;
            tGTrack2.setNumber(n2);
            ++n2;
        }
        this.getSong().removeTrack(tGTrack);
    }

    private void orderTracks() {
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack = null;
            for (int j = i; j < this.getSong().countTracks(); ++j) {
                TGTrack tGTrack2 = this.getSong().getTrack(j);
                if (tGTrack != null && tGTrack2.getNumber() >= tGTrack.getNumber()) continue;
                tGTrack = tGTrack2;
            }
            this.getSong().moveTrack(i, tGTrack);
        }
    }

    public TGSong newSong() {
        TGSong tGSong = this.getFactory().newSong();
        TGMeasureHeader tGMeasureHeader = this.getFactory().newHeader();
        tGMeasureHeader.setNumber(1);
        tGMeasureHeader.setStart(1000L);
        tGMeasureHeader.getTimeSignature().setNumerator(4);
        tGMeasureHeader.getTimeSignature().getDenominator().setValue(4);
        tGSong.addMeasureHeader(tGMeasureHeader);
        TGMeasure tGMeasure = this.getFactory().newMeasure(tGMeasureHeader);
        TGTrack tGTrack = this.getFactory().newTrack();
        tGTrack.setNumber(1);
        tGTrack.setName("Track 1");
        tGTrack.addMeasure(tGMeasure);
        tGTrack.getChannel().setChannel((short)0);
        tGTrack.getChannel().setEffectChannel((short)1);
        tGTrack.getChannel().setInstrument((short)0);
        tGTrack.setStrings(this.createDefaultInstrumentStrings());
        TGColor.RED.copy(tGTrack.getColor());
        tGSong.addTrack(tGTrack);
        return tGSong;
    }

    public int getNextTrackNumber() {
        return this.getSong().countTracks() + 1;
    }

    public TGChannel getFreeChannel(short s, boolean bl) {
        if (bl) {
            return TGChannel.newPercusionChannel(this.getFactory());
        }
        short s2 = -1;
        short s3 = -1;
        boolean[] blArray = this.getUsedChannels();
        boolean[] blArray2 = this.getUsedEffectChannels();
        for (short s4 = 0; s4 < 16; s4 = (short)((short)(s4 + 1))) {
            if (TGChannel.isPercussionChannel(s4) || blArray[s4] || blArray2[s4]) continue;
            s2 = s2 < 0 ? s4 : s2;
            s3 = s3 < 0 && s4 != s2 ? s4 : s3;
        }
        if (s2 < 0 || s3 < 0) {
            if (s2 >= 0) {
                s3 = s2;
            } else {
                TGChannel tGChannel = this.getLastTrack().getChannel();
                return tGChannel.clone(this.getFactory());
            }
        }
        TGChannel tGChannel = this.getFactory().newChannel();
        tGChannel.setChannel(s2);
        tGChannel.setEffectChannel(s3);
        tGChannel.setInstrument(s);
        return tGChannel;
    }

    public boolean[] getUsedEffectChannels() {
        boolean[] blArray = new boolean[16];
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.getSong().getTrack(i);
            blArray[tGTrack.getChannel().getEffectChannel()] = true;
        }
        return blArray;
    }

    public boolean[] getUsedChannels() {
        boolean[] blArray = new boolean[16];
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.getSong().getTrack(i);
            blArray[tGTrack.getChannel().getChannel()] = true;
        }
        return blArray;
    }

    public TGChannel getUsedChannel(int n) {
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.getSong().getTrack(i);
            if (n != tGTrack.getChannel().getChannel()) continue;
            return tGTrack.getChannel().clone(this.getFactory());
        }
        return null;
    }

    public int countTracksForChannel(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.getSong().getTrack(i);
            if (n != tGTrack.getChannel().getChannel()) continue;
            ++n2;
        }
        return n2;
    }

    public void updateChannel(TGChannel tGChannel) {
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.getSong().getTrack(i);
            if (tGChannel.getChannel() != tGTrack.getChannel().getChannel()) continue;
            tGTrack.setChannel(tGChannel.clone(this.getFactory()));
        }
    }

    public TGTrack getTrack(int n) {
        TGTrack tGTrack = null;
        for (int i = 0; i < this.getSong().countTracks(); ++i) {
            TGTrack tGTrack2 = this.getSong().getTrack(i);
            if (tGTrack2.getNumber() != n) continue;
            tGTrack = tGTrack2;
            break;
        }
        return tGTrack;
    }

    public TGTrack getFirstTrack() {
        TGTrack tGTrack = null;
        if (!this.getSong().isEmpty()) {
            tGTrack = this.getSong().getTrack(0);
        }
        return tGTrack;
    }

    public TGTrack getLastTrack() {
        TGTrack tGTrack = null;
        if (!this.getSong().isEmpty()) {
            tGTrack = this.getSong().getTrack(this.getSong().countTracks() - 1);
        }
        return tGTrack;
    }

    public TGTrack cloneTrack(TGTrack tGTrack) {
        TGTrack tGTrack2 = tGTrack.clone(this.getFactory(), this.getSong());
        tGTrack2.setNumber(this.getNextTrackNumber());
        this.addTrack(tGTrack2);
        return tGTrack2;
    }

    public boolean moveTrackUp(TGTrack tGTrack) {
        if (tGTrack.getNumber() > 1) {
            TGTrack tGTrack2 = this.getTrack(tGTrack.getNumber() - 1);
            tGTrack2.setNumber(tGTrack2.getNumber() + 1);
            tGTrack.setNumber(tGTrack.getNumber() - 1);
            this.orderTracks();
            return true;
        }
        return false;
    }

    public boolean moveTrackDown(TGTrack tGTrack) {
        if (tGTrack.getNumber() < this.getSong().countTracks()) {
            TGTrack tGTrack2 = this.getTrack(tGTrack.getNumber() + 1);
            tGTrack2.setNumber(tGTrack2.getNumber() - 1);
            tGTrack.setNumber(tGTrack.getNumber() + 1);
            this.orderTracks();
            return true;
        }
        return false;
    }

    private TGTrack makeNewTrack() {
        TGTrack tGTrack = this.getFactory().newTrack();
        tGTrack.setNumber(this.getNextTrackNumber());
        tGTrack.setName("Track " + tGTrack.getNumber());
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            TGMeasure tGMeasure = this.getFactory().newMeasure(tGMeasureHeader);
            tGTrack.addMeasure(tGMeasure);
        }
        tGTrack.setStrings(this.createDefaultInstrumentStrings());
        this.getFreeChannel((short)0, false).copy(tGTrack.getChannel());
        TGColor.RED.copy(tGTrack.getColor());
        return tGTrack;
    }

    public TGTrack createTrack() {
        TGTrack tGTrack = null;
        if (this.getSong().isEmpty()) {
            this.setSong(this.newSong());
            tGTrack = this.getLastTrack();
        } else {
            tGTrack = this.makeNewTrack();
        }
        this.addTrack(tGTrack);
        return tGTrack;
    }

    public void removeTrack(TGTrack tGTrack) {
        this.removeTrack(tGTrack.getNumber());
    }

    public void changeTimeSignature(long l, TGTimeSignature tGTimeSignature, boolean bl) {
        this.changeTimeSignature(this.getMeasureHeaderAt(l), tGTimeSignature, bl);
    }

    public void changeTimeSignature(TGMeasureHeader tGMeasureHeader, TGTimeSignature tGTimeSignature, boolean bl) {
        tGTimeSignature.copy(tGMeasureHeader.getTimeSignature());
        long l = tGMeasureHeader.getStart() + tGMeasureHeader.getLength();
        List list = this.getMeasureHeadersBeforeEnd(tGMeasureHeader.getStart() + 1L);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            long l2 = l - tGMeasureHeader2.getStart();
            this.moveMeasureComponents(tGMeasureHeader2, l2);
            this.moveMeasureHeader(tGMeasureHeader2, l2, 0);
            if (bl) {
                tGTimeSignature.copy(tGMeasureHeader2.getTimeSignature());
            }
            l = tGMeasureHeader2.getStart() + tGMeasureHeader2.getLength();
        }
    }

    public void changeTripletFeel(long l, int n, boolean bl) {
        this.changeTripletFeel(this.getMeasureHeaderAt(l), n, bl);
    }

    public void changeTripletFeel(TGMeasureHeader tGMeasureHeader, int n, boolean bl) {
        tGMeasureHeader.setTripletFeel(n);
        if (bl) {
            List list = this.getMeasureHeadersBeforeEnd(tGMeasureHeader.getStart() + 1L);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
                tGMeasureHeader2.setTripletFeel(n);
            }
        }
    }

    public void changeTempos(long l, TGTempo tGTempo, boolean bl) {
        this.changeTempos(this.getMeasureHeaderAt(l), tGTempo, bl);
    }

    public void changeTempos(TGMeasureHeader tGMeasureHeader, TGTempo tGTempo, boolean bl) {
        int n = tGMeasureHeader.getTempo().getValue();
        Iterator iterator = this.getMeasureHeadersAfter(tGMeasureHeader.getNumber() - 1).iterator();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            if (!bl && tGMeasureHeader2.getTempo().getValue() != n) break;
            this.changeTempo(tGMeasureHeader2, tGTempo);
        }
    }

    public void changeTempo(TGMeasureHeader tGMeasureHeader, TGTempo tGTempo) {
        tGTempo.copy(tGMeasureHeader.getTempo());
    }

    public void changeOpenRepeat(long l) {
        TGMeasureHeader tGMeasureHeader;
        tGMeasureHeader.setRepeatOpen(!(tGMeasureHeader = this.getMeasureHeaderAt(l)).isRepeatOpen());
    }

    public void changeCloseRepeat(long l, int n) {
        TGMeasureHeader tGMeasureHeader = this.getMeasureHeaderAt(l);
        tGMeasureHeader.setRepeatClose(n);
    }

    public void changeAlternativeRepeat(long l, int n) {
        TGMeasureHeader tGMeasureHeader = this.getMeasureHeaderAt(l);
        tGMeasureHeader.setRepeatAlternative(n);
    }

    public TGMeasureHeader addNewMeasureBeforeEnd() {
        TGMeasureHeader tGMeasureHeader = this.getLastMeasureHeader();
        TGMeasureHeader tGMeasureHeader2 = this.getFactory().newHeader();
        tGMeasureHeader2.setNumber(tGMeasureHeader.getNumber() + 1);
        tGMeasureHeader2.setStart(tGMeasureHeader.getStart() + tGMeasureHeader.getLength());
        tGMeasureHeader2.setRepeatOpen(false);
        tGMeasureHeader2.setRepeatClose(0);
        tGMeasureHeader2.setTripletFeel(tGMeasureHeader.getTripletFeel());
        tGMeasureHeader.getTimeSignature().copy(tGMeasureHeader2.getTimeSignature());
        tGMeasureHeader.getTempo().copy(tGMeasureHeader2.getTempo());
        this.getSong().addMeasureHeader(tGMeasureHeader2);
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.getTrackManager().addNewMeasureBeforeEnd(tGTrack, tGMeasureHeader2);
        }
        return tGMeasureHeader2;
    }

    public void addNewMeasure(int n) {
        TGMeasureHeader tGMeasureHeader = null;
        if (n == 1) {
            tGMeasureHeader = this.getMeasureHeader(n).clone(this.getFactory());
        } else {
            tGMeasureHeader = this.getMeasureHeader(n - 1).clone(this.getFactory());
            tGMeasureHeader.setStart(tGMeasureHeader.getStart() + tGMeasureHeader.getLength());
            tGMeasureHeader.setNumber(tGMeasureHeader.getNumber() + 1);
        }
        tGMeasureHeader.setMarker(null);
        tGMeasureHeader.setRepeatOpen(false);
        tGMeasureHeader.setRepeatAlternative(0);
        tGMeasureHeader.setRepeatClose(0);
        TGMeasureHeader tGMeasureHeader2 = this.getMeasureHeader(n);
        if (tGMeasureHeader2 != null) {
            this.moveMeasureHeaders(this.getMeasureHeadersBeforeEnd(tGMeasureHeader2.getStart()), tGMeasureHeader.getLength(), 1, true);
        }
        this.addMeasureHeader(tGMeasureHeader.getNumber() - 1, tGMeasureHeader);
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.getTrackManager().addNewMeasure(tGTrack, tGMeasureHeader);
        }
    }

    public List getMeasures(long l) {
        ArrayList<TGMeasure> arrayList = new ArrayList<TGMeasure>();
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            TGMeasure tGMeasure = this.getTrackManager().getMeasureAt(tGTrack, l);
            if (tGMeasure == null) continue;
            arrayList.add(tGMeasure);
        }
        return arrayList;
    }

    public TGTrack replaceTrack(TGTrack tGTrack) {
        TGTrack tGTrack2 = this.getTrack(tGTrack.getNumber());
        if (tGTrack2 != null) {
            tGTrack.copy(this.getFactory(), this.getSong(), tGTrack2);
        }
        return tGTrack2;
    }

    public TGMeasureHeader getFirstMeasureHeader() {
        TGMeasureHeader tGMeasureHeader = null;
        for (int i = 0; i < this.getSong().countMeasureHeaders(); ++i) {
            TGMeasureHeader tGMeasureHeader2 = this.getSong().getMeasureHeader(i);
            if (tGMeasureHeader != null && tGMeasureHeader2.getStart() >= tGMeasureHeader.getStart()) continue;
            tGMeasureHeader = tGMeasureHeader2;
        }
        return tGMeasureHeader;
    }

    public TGMeasureHeader getLastMeasureHeader() {
        int n = this.getSong().countMeasureHeaders() - 1;
        return this.getSong().getMeasureHeader(n);
    }

    public TGMeasureHeader getPrevMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        int n = tGMeasureHeader.getNumber() - 1;
        if (n > 0) {
            return this.getSong().getMeasureHeader(n - 1);
        }
        return null;
    }

    public TGMeasureHeader getNextMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        int n = tGMeasureHeader.getNumber();
        if (n < this.getSong().countMeasureHeaders()) {
            return this.getSong().getMeasureHeader(n);
        }
        return null;
    }

    public TGMeasureHeader getMeasureHeaderAt(long l) {
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            long l2 = tGMeasureHeader.getStart();
            long l3 = tGMeasureHeader.getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return tGMeasureHeader;
        }
        return null;
    }

    public TGMeasureHeader getMeasureHeader(int n) {
        for (int i = 0; i < this.getSong().countMeasureHeaders(); ++i) {
            TGMeasureHeader tGMeasureHeader = this.getSong().getMeasureHeader(i);
            if (tGMeasureHeader.getNumber() != n) continue;
            return tGMeasureHeader;
        }
        return null;
    }

    public List getMeasureHeadersBeforeEnd(long l) {
        ArrayList<TGMeasureHeader> arrayList = new ArrayList<TGMeasureHeader>();
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            if (tGMeasureHeader.getStart() < l) continue;
            arrayList.add(tGMeasureHeader);
        }
        return arrayList;
    }

    public List getMeasureHeadersAfter(int n) {
        ArrayList<TGMeasureHeader> arrayList = new ArrayList<TGMeasureHeader>();
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            if (tGMeasureHeader.getNumber() <= n) continue;
            arrayList.add(tGMeasureHeader);
        }
        return arrayList;
    }

    public List getMeasureHeadersBetween(long l, long l2) {
        ArrayList<TGMeasureHeader> arrayList = new ArrayList<TGMeasureHeader>();
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            if (tGMeasureHeader.getStart() + tGMeasureHeader.getLength() <= l || tGMeasureHeader.getStart() >= l2) continue;
            arrayList.add(tGMeasureHeader);
        }
        return arrayList;
    }

    public void removeLastMeasure() {
        this.removeLastMeasureHeader();
    }

    public void removeMeasure(long l) {
        this.removeMeasureHeader(l);
    }

    public void removeMeasure(int n) {
        this.removeMeasureHeader(n);
    }

    public void addMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        this.getSong().addMeasureHeader(tGMeasureHeader);
    }

    public void addMeasureHeader(int n, TGMeasureHeader tGMeasureHeader) {
        this.getSong().addMeasureHeader(n, tGMeasureHeader);
    }

    public void removeMeasureHeaders(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            TGMeasureHeader tGMeasureHeader = this.getMeasureHeader(n);
            this.removeMeasureHeader(tGMeasureHeader);
        }
    }

    public void removeLastMeasureHeader() {
        this.removeMeasureHeader(this.getLastMeasureHeader());
    }

    public void removeMeasureHeader(long l) {
        this.removeMeasureHeader(this.getMeasureHeaderAt(l));
    }

    public void removeMeasureHeader(int n) {
        this.removeMeasureHeader(this.getMeasureHeader(n));
    }

    public void removeMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        long l = tGMeasureHeader.getStart();
        long l2 = tGMeasureHeader.getLength();
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.getTrackManager().removeMeasure(tGTrack, l);
        }
        this.moveMeasureHeaders(this.getMeasureHeadersBeforeEnd(l + 1L), -l2, -1, true);
        this.getSong().removeMeasureHeader(tGMeasureHeader.getNumber() - 1);
    }

    public TGMeasureHeader replaceMeasureHeader(TGMeasureHeader tGMeasureHeader) {
        TGMeasureHeader tGMeasureHeader2 = this.getMeasureHeaderAt(tGMeasureHeader.getStart());
        tGMeasureHeader2.makeEqual(tGMeasureHeader.clone(this.getFactory()));
        return tGMeasureHeader2;
    }

    public void moveMeasureHeaders(List list, long l, int n, boolean bl) {
        TGMeasureHeader tGMeasureHeader;
        Iterator iterator;
        if (bl) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                tGMeasureHeader = (TGMeasureHeader)iterator.next();
                this.moveMeasureComponents(tGMeasureHeader, l);
            }
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            tGMeasureHeader = (TGMeasureHeader)iterator.next();
            this.moveMeasureHeader(tGMeasureHeader, l, n);
        }
    }

    public void moveMeasureHeader(TGMeasureHeader tGMeasureHeader, long l, int n) {
        tGMeasureHeader.setNumber(tGMeasureHeader.getNumber() + n);
        tGMeasureHeader.setStart(tGMeasureHeader.getStart() + l);
    }

    public void moveMeasureComponents(TGMeasureHeader tGMeasureHeader, long l) {
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.getTrackManager().moveMeasure(this.getTrackManager().getMeasure(tGTrack, tGMeasureHeader.getNumber()), l);
        }
    }

    public boolean isAtPosition(TGMeasureHeader tGMeasureHeader, long l) {
        return l >= tGMeasureHeader.getStart() && l < tGMeasureHeader.getStart() + tGMeasureHeader.getLength();
    }

    public TGMarker updateMarker(int n, String string, TGColor tGColor) {
        TGMeasureHeader tGMeasureHeader = this.getMeasureHeader(n);
        if (tGMeasureHeader != null) {
            if (!tGMeasureHeader.hasMarker()) {
                tGMeasureHeader.setMarker(this.getFactory().newMarker());
            }
            tGMeasureHeader.getMarker().setMeasure(n);
            tGMeasureHeader.getMarker().setTitle(string);
            tGMeasureHeader.getMarker().getColor().setR(tGColor.getR());
            tGMeasureHeader.getMarker().getColor().setG(tGColor.getG());
            tGMeasureHeader.getMarker().getColor().setB(tGColor.getB());
        }
        return null;
    }

    public TGMarker updateMarker(TGMarker tGMarker) {
        return this.updateMarker(tGMarker.getMeasure(), tGMarker.getTitle(), tGMarker.getColor());
    }

    public void removeMarker(TGMarker tGMarker) {
        if (tGMarker != null) {
            this.removeMarker(tGMarker.getMeasure());
        }
    }

    public void removeMarker(int n) {
        TGMeasureHeader tGMeasureHeader = this.getMeasureHeader(n);
        if (tGMeasureHeader != null && tGMeasureHeader.hasMarker()) {
            tGMeasureHeader.setMarker(null);
        }
    }

    public void removeAllMarkers() {
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            if (!tGMeasureHeader.hasMarker()) continue;
            tGMeasureHeader.setMarker(null);
        }
    }

    public List getMarkers() {
        ArrayList<TGMarker> arrayList = new ArrayList<TGMarker>();
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            if (!tGMeasureHeader.hasMarker()) continue;
            arrayList.add(tGMeasureHeader.getMarker());
        }
        return arrayList;
    }

    public TGMarker getMarker(int n) {
        TGMeasureHeader tGMeasureHeader = this.getMeasureHeader(n);
        if (tGMeasureHeader != null && tGMeasureHeader.hasMarker()) {
            return tGMeasureHeader.getMarker();
        }
        return null;
    }

    public TGMarker getPreviousMarker(int n) {
        TGMeasureHeader tGMeasureHeader = null;
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            if (!tGMeasureHeader2.hasMarker() || tGMeasureHeader2.getNumber() >= n || tGMeasureHeader != null && tGMeasureHeader.getNumber() >= tGMeasureHeader2.getNumber()) continue;
            tGMeasureHeader = tGMeasureHeader2;
        }
        return tGMeasureHeader != null ? tGMeasureHeader.getMarker() : null;
    }

    public TGMarker getNextMarker(int n) {
        TGMeasureHeader tGMeasureHeader = null;
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            if (!tGMeasureHeader2.hasMarker() || tGMeasureHeader2.getNumber() <= n || tGMeasureHeader != null && tGMeasureHeader.getNumber() <= tGMeasureHeader2.getNumber()) continue;
            tGMeasureHeader = tGMeasureHeader2;
        }
        return tGMeasureHeader != null ? tGMeasureHeader.getMarker() : null;
    }

    public TGMarker getFirstMarker() {
        TGMeasureHeader tGMeasureHeader = null;
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            if (!tGMeasureHeader2.hasMarker() || tGMeasureHeader != null && tGMeasureHeader2.getNumber() >= tGMeasureHeader.getNumber()) continue;
            tGMeasureHeader = tGMeasureHeader2;
        }
        return tGMeasureHeader != null ? tGMeasureHeader.getMarker() : null;
    }

    public TGMarker getLastMarker() {
        TGMeasureHeader tGMeasureHeader = null;
        Iterator iterator = this.getSong().getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            if (!tGMeasureHeader2.hasMarker() || tGMeasureHeader != null && tGMeasureHeader2.getNumber() <= tGMeasureHeader.getNumber()) continue;
            tGMeasureHeader = tGMeasureHeader2;
        }
        return tGMeasureHeader != null ? tGMeasureHeader.getMarker() : null;
    }

    public void autoCompleteSilences() {
        Iterator iterator = this.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.getTrackManager().autoCompleteSilences(tGTrack);
        }
    }

    public List createDefaultInstrumentStrings() {
        ArrayList<TGString> arrayList = new ArrayList<TGString>();
        arrayList.add(TGSongManager.newString(this.getFactory(), 1, 64));
        arrayList.add(TGSongManager.newString(this.getFactory(), 2, 59));
        arrayList.add(TGSongManager.newString(this.getFactory(), 3, 55));
        arrayList.add(TGSongManager.newString(this.getFactory(), 4, 50));
        arrayList.add(TGSongManager.newString(this.getFactory(), 5, 45));
        arrayList.add(TGSongManager.newString(this.getFactory(), 6, 40));
        return arrayList;
    }

    public static List createPercusionStrings(TGFactory tGFactory, int n) {
        ArrayList<TGString> arrayList = new ArrayList<TGString>();
        for (int i = 1; i <= n; ++i) {
            arrayList.add(TGSongManager.newString(tGFactory, i, 0));
        }
        return arrayList;
    }

    public static TGString newString(TGFactory tGFactory, int n, int n2) {
        TGString tGString = tGFactory.newString();
        tGString.setNumber(n);
        tGString.setValue(n2);
        return tGString;
    }

    public static long getDivisionLength(TGMeasureHeader tGMeasureHeader) {
        long l = 1000L;
        int n = tGMeasureHeader.getTimeSignature().getDenominator().getValue();
        switch (n) {
            case 8: {
                if (tGMeasureHeader.getTimeSignature().getNumerator() % 3 != 0) break;
                l += 500L;
            }
        }
        return l;
    }
}

